package suning.service.service;

import com.suning.api.entity.govbus.*;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsConfigApi;
import goods.model.*;
import goods.model.repository.*;
import goods.vo.GoodsConfigUpdateMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Example;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import suning.api.good.SnCategoryApi;
import suning.api.good.SnProductApi;
import suning.api.price.SnPriceApi;
import suning.model.TestMatchCategoryData;
import suning.model.repository.TMCDRepo;
import utils.GlobalContants;
import utils.Lang;
import utils.date.DateUtils;
import utils.log.Log;
import utils.log.Logs;
import utils.web.ResponseMapUtils;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * Created by Roney on 2017-04-07.
 */
@Component
@Transactional
public class SnProdService {
    private final static Log log = Logs.getLog(SnProdService.class.getName());

    @Value("${suning.store.code}")
    private String sn_code;

    @Value("${suning.store.id}")
    private String sn_id;

    @Autowired
    SnCategoryApi snCategoryApi;

    @Autowired
    SnProductApi snProductApi;

    @Autowired
    SnPriceApi snPriceApi;

    @Autowired
    ProductRepos productRepos;

    @Autowired
    GoodsRepos goodsRepos;

    @Autowired
    ProductCategoryRepos productCategoryRepos;

    @Autowired
    ProductCategoryExtTaxRateRepos productCategoryExtTaxRateRepos;

    @Autowired
    TMCDRepo tMCDRepo;

    @MotanReferer
    GoodsConfigApi goodsConfigApi;

    public Map getCategory() {
        Map returnMap = new HashMap();
        CategoryGetRequest request = new CategoryGetRequest();
        request.setCheckParam(true);
        returnMap.put("result", snCategoryApi.getCategory(request));
        return returnMap;
    }

    public Map getProdPool(String categoryId) {
        Map returnMap = new HashMap();
        ProdPoolQueryRequest request = new ProdPoolQueryRequest();
        request.setCategoryId(categoryId);
        request.setCheckParam(true);
        returnMap.put("result", snProductApi.queryProdPool(request));
        return returnMap;
    }

    public Map getProdDetail(String skuid) {
        Map returnMap = new HashMap();
        ProdDetailGetRequest request = new ProdDetailGetRequest();
        request.setSkuId(skuid);
        request.setCheckParam(true);
        returnMap.put("result", snProductApi.getProdDetail(request));
        return returnMap;
    }

    public Map getProdImage(String skuid) {
        Map returnMap = new HashMap();
        ProdImageQueryRequest request = new ProdImageQueryRequest();
        List<ProdImageQueryRequest.SkuIds> list = new ArrayList<ProdImageQueryRequest.SkuIds>();
        ProdImageQueryRequest.SkuIds skuIds = new ProdImageQueryRequest.SkuIds();
        skuIds.setSkuId(skuid);
        list.add(skuIds);
        request.setSkuIds(list);
        request.setCheckParam(true);
        returnMap.put("result", snProductApi.queryProdImage(request));
        return returnMap;
    }

    public Map getProdReview(String skuid) {
        Map returnMap = new HashMap();
        ProdReviewQueryRequest request = new ProdReviewQueryRequest();
        List<ProdReviewQueryRequest.SkuIds> skuIdses = new ArrayList<>();
        ProdReviewQueryRequest.SkuIds skuIds = new ProdReviewQueryRequest.SkuIds();
        skuIds.setSkuId(skuid);
        skuIdses.add(skuIds);
        request.setSkuIds(skuIdses);
        snProductApi.queryProdReview(request);
        returnMap.put("result", snProductApi.queryProdReview(request));
        return returnMap;
    }

    public List<Map<String, String>> getBatchProdSaleStatus(List<Map<String, String>> params) {
        BatchProdSaleStatusGetRequest request = new BatchProdSaleStatusGetRequest();
        List<BatchProdSaleStatusGetRequest.SkuIds> skuIdsList = new ArrayList<BatchProdSaleStatusGetRequest.SkuIds>();
        int paramsSize = params.size();
        List<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        for (int i = 0; i < paramsSize; i++) {
            BatchProdSaleStatusGetRequest.SkuIds skuIds = new BatchProdSaleStatusGetRequest.SkuIds();
            skuIds.setSkuId(params.get(i).get("skuId"));
            skuIdsList.add(skuIds);
            if (i != 0 && i % 49 == 0 || paramsSize - 1 == i) {
                request.setSkuIds(skuIdsList);
                BatchProdSaleStatusGetResponse response = snProductApi.getBatchProdSaleStatus(request);
                if (response.getSnerror() != null) {
                    return null;
                }
                List<BatchProdSaleStatusGetResponse.OnShelvesList> onShelvesLists = response.getSnbody().getGetBatchProdSaleStatus().getOnShelvesList();
                for (BatchProdSaleStatusGetResponse.OnShelvesList onShelvesList : onShelvesLists) {
                    Map<String, String> resultMap = new HashMap<String, String>();
                    resultMap.put("skuId", onShelvesList.getSkuId());
                    resultMap.put("state", onShelvesList.getState());
                    resultList.add(resultMap);
                }
                skuIdsList.clear();
            }
        }
        return resultList;
    }

    public Map addProdBySkus(Map resMap, String skuids, String categoryId, String categoryName, String cmmdtyType) {
        resMap = ResponseMapUtils.success(null);
        Map rsData = new HashMap<>();
        List<Map> errorDetail = new ArrayList<>();
        if (!Lang.isEmpty(skuids)) {
            List<String> skuList = new ArrayList<>();
            if (skuids.contains(",")) {
                String[] skuArr = skuids.split(",");
                for (String s : skuArr) {
                    if (!Lang.isEmpty(s)) {
                        skuList.add(s.trim());
                    }
                }
            } else {
                skuList.add(skuids.trim());
            }

            int sucCount = 0;
            int errorCount = 0;
            int totalCount = skuList.size();
            String goodsId = null;
            List<String> goodsIds = new ArrayList<>();
            for (String sku : skuList) {
                goodsId = null;
                CategoryGetResponse.ResultInfo categoryResult = null;
                if (!Lang.isEmpty(categoryId)) {
                    categoryResult = new CategoryGetResponse.ResultInfo();
                    categoryResult.setCategoryId(categoryId);
                    categoryResult.setCategoryName(categoryName);
                }

                ProdPoolQueryResponse.ResultInfo pool = new ProdPoolQueryResponse.ResultInfo();
                pool.setCmmdtyType(Lang.isEmpty(cmmdtyType) ? "1" : cmmdtyType); // 默认同步1普通商品
                pool.setSkuId(sku);
                try {
                    goodsId = this.addGoods(categoryResult, pool);
                    if (!Lang.isEmpty(goodsId)) {
                        goodsIds.add(goodsId);
                    }
                    sucCount++;
                } catch (Exception e) {
                    errorCount++;
                    errorDetail.add(new HashMap() {{
                        put("sku", sku);
                        put("message", e.getLocalizedMessage());
                    }});
                    e.printStackTrace();
                }
            }

            /**Akers 2017-09-15修改： 同步商品时同步新增GoodsConfig START */
            // 异步触发GoodsConfig生成
            String storeCode = "suning";
            // TODO: 2018/9/4 初始化方法临时注释
            if (true) {
                throw new RuntimeException("该方法需要调整");
            }
//            goodsConfigApi.addOrUpdateMallGoods(skuList,storeCode);
            /**Akers 2017-09-15修改： 同步商品时同步新增GoodsConfig END */
            rsData.put("suc", sucCount);
            rsData.put("error", errorCount);
            rsData.put("total", totalCount);
            rsData.put("errorDetail", errorDetail);
            resMap.put("data", rsData);
        } else {
            resMap = ResponseMapUtils.error("skuids必传，多个sku用','隔开", "2");
        }

        return resMap;
    }


    class ProdPoolThread extends Thread {

        CategoryGetResponse.ResultInfo categoryResultInfo;

        ProdPoolThread(CategoryGetResponse.ResultInfo categoryResultInfo) {
            this.categoryResultInfo = categoryResultInfo;
        }

        @Override
        public void run() {
            queryProdPool(categoryResultInfo);
        }
    }

    class GoodsThread extends Thread {
        CategoryGetResponse.ResultInfo categoryResultInfo;
        ProdPoolQueryResponse.ResultInfo prodPoolResultInfo;

        GoodsThread(CategoryGetResponse.ResultInfo categoryResultInfo, ProdPoolQueryResponse.ResultInfo prodPoolResultInfo) {
            this.categoryResultInfo = categoryResultInfo;
            this.prodPoolResultInfo = prodPoolResultInfo;
        }

        @Override
        public void run() {
            addGoods(categoryResultInfo, prodPoolResultInfo);
        }
    }

    public void initProd() {
        CategoryGetRequest categoryReq = new CategoryGetRequest();
        CategoryGetResponse categoryRes = snCategoryApi.getCategory(categoryReq);
        if (categoryRes.getSnerror() == null) {
            List<CategoryGetResponse.ResultInfo> categoryResult = categoryRes.getSnbody().getGetCategory().getResultInfo();


            ExecutorService pool = Executors.newFixedThreadPool(10);
            for (int i = 0; i < categoryResult.size(); i++) {
                try {
                    ProdPoolThread prodPoolThread = new ProdPoolThread(categoryResult.get(i));
                    pool.execute(prodPoolThread);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            if (!pool.isShutdown()) {
                pool.shutdown();
            }
        } else {
            throw new RuntimeException("同步商品目录出错。");
        }

    }

    public void queryProdPool(CategoryGetResponse.ResultInfo categoryResult) {
        ProdPoolQueryRequest poolReq = new ProdPoolQueryRequest();
        poolReq.setCategoryId(categoryResult.getCategoryId());
        poolReq.setCheckParam(true);
        ProdPoolQueryResponse poolRes = snProductApi.queryProdPool(poolReq);
        if (poolRes.getSnerror() == null) {
            List<ProdPoolQueryResponse.ResultInfo> poolList = poolRes.getSnbody().getQueryProdPool().getResultInfo();
            List<List<ProdPoolQueryResponse.ResultInfo>> totalList = splitList(poolList);
            ExecutorService pool = Executors.newFixedThreadPool(20);
            int totalListSize = totalList.size();
            for (int i = 0; i < totalListSize; i++) {
                List<ProdPoolQueryResponse.ResultInfo> resultList = totalList.get(i);
                int resultListSize = resultList.size();
                for (int j = 0; j < resultListSize; j++) {
                    try {
                        GoodsThread goodsThread = new GoodsThread(categoryResult, resultList.get(j));
                        pool.execute(goodsThread);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            if (!pool.isShutdown()) {
                pool.shutdown();
            }
        } else {
            throw new RuntimeException("同步商品池出错，商品池编号:" + poolReq.getCategoryId());
        }
    }

    public List<List<ProdPoolQueryResponse.ResultInfo>> splitList(List<ProdPoolQueryResponse.ResultInfo> prodPool) {
        List<List<ProdPoolQueryResponse.ResultInfo>> totalProdPool = new ArrayList<List<ProdPoolQueryResponse.ResultInfo>>();
        int totalListSize = prodPool.size();
        int sumListSize = totalListSize / 2000;
        if (totalListSize % 2000 != 0) {
            sumListSize++;
        }
        for (int i = 0; i < sumListSize; i++) {
            if (i == sumListSize - 1) {
                totalProdPool.add(prodPool.subList(i * 2000, totalListSize));
                break;
            }
            totalProdPool.add(prodPool.subList(i * 2000, (i + 1) * 2000));
        }
        return totalProdPool;
    }

    public String addGoods(CategoryGetResponse.ResultInfo categoryResult, ProdPoolQueryResponse.ResultInfo pool) {
        String goodsId = null;
        ProdDetailGetRequest detailReq = new ProdDetailGetRequest();
        detailReq.setSkuId(pool.getSkuId());
        ProdDetailGetResponse detailRes = snProductApi.getProdDetail(detailReq);
        if (detailRes.getSnerror() == null) {
            ProdDetailGetResponse.GetProdDetail prodDetail = detailRes.getSnbody().getGetProdDetail();
            //商品图片
            ProdImageQueryRequest imageReq = new ProdImageQueryRequest();
            List<ProdImageQueryRequest.SkuIds> imageSkuIdses = new ArrayList<ProdImageQueryRequest.SkuIds>();
            ProdImageQueryRequest.SkuIds skuIds = new ProdImageQueryRequest.SkuIds();
            skuIds.setSkuId(prodDetail.getSkuId());
            imageSkuIdses.add(skuIds);
            imageReq.setSkuIds(imageSkuIdses);
            ProdImageQueryResponse imageRes = snProductApi.queryProdImage(imageReq);
            if (imageRes.getSnerror() != null) {
                throw new RuntimeException("同步商品图片出错，商品编号:" + pool.getSkuId());
            }
            ProdImageQueryResponse.ResultInfo imageResult = imageRes.getSnbody().getQueryProdImage().getResultInfo().get(0);
            //商品上下架状态
            BatchProdSaleStatusGetRequest batchProdSaleStatusGetRequest = new BatchProdSaleStatusGetRequest();
            List<BatchProdSaleStatusGetRequest.SkuIds> batchSkuidses = new ArrayList<BatchProdSaleStatusGetRequest.SkuIds>();
            BatchProdSaleStatusGetRequest.SkuIds batchSkuids = new BatchProdSaleStatusGetRequest.SkuIds();
            batchSkuids.setSkuId(prodDetail.getSkuId());
            batchSkuidses.add(batchSkuids);
            batchProdSaleStatusGetRequest.setSkuIds(batchSkuidses);
            BatchProdSaleStatusGetResponse batchRes = snProductApi.getBatchProdSaleStatus(batchProdSaleStatusGetRequest);
            if (imageRes.getSnerror() != null) {
                throw new RuntimeException("同步商品上下架状态出错，商品编号:" + pool.getSkuId());
            }
            BatchProdSaleStatusGetResponse.OnShelvesList onShelvesList = batchRes.getSnbody().getGetBatchProdSaleStatus().getOnShelvesList().get(0);

            PriceQueryRequest priceReq = new PriceQueryRequest();
            PriceQueryRequest.Skus priceSkus = new PriceQueryRequest.Skus();
            priceSkus.setSkuId(pool.getSkuId());
            priceReq.setSkus(Arrays.asList(priceSkus));
            String cityId = "010";
            priceReq.setCityId(cityId);//默认一个地址，先算出苏宁价格，方便走索引
            PriceQueryResponse priceRes = snPriceApi.queryPrice(priceReq);
            if (priceRes.getSnerror() != null) {
                cityId = "021";
                priceReq.setCityId(cityId);
                priceRes = snPriceApi.queryPrice(priceReq);
                if (priceRes.getSnerror() != null) {
                    System.out.println(priceRes.getSnerror().getErrorMsg());
                    throw new RuntimeException("同步商品价格出错，商品编号:" + pool.getSkuId());
                }
            }
            PriceQueryResponse.Skus priceResSkus = priceRes.getSnbody().getQueryPrice().getSkus().get(0);
            /***
             * 查询商品是否支持开增值税发票
             * start
             */
            Boolean isDelete = false;
            ProdextendGetRequest request = new ProdextendGetRequest();
            ProdextendGetRequest.Skus prodExtSkus = new ProdextendGetRequest.Skus();
            prodExtSkus.setSkuId(pool.getSkuId());
            request.setSkus(Arrays.asList(prodExtSkus));
            ProdextendGetResponse prodextendGetResponse = snProductApi.getProdextend(request);
            if (!Lang.isEmpty(prodextendGetResponse) && !Lang.isEmpty(prodextendGetResponse.getSnbody()) && !Lang.isEmpty(prodextendGetResponse.getSnbody().getGetProdextend())) {
                if (prodextendGetResponse.getSnbody().getGetProdextend().getIsSuccess().equals("Y")) {
                    if (prodextendGetResponse.getSnbody().getGetProdextend().getResultInfo().get(0).getIncreaseTicket().equals("02")) {
                        isDelete = true;
                    }
                }
            }

            /***
             * 查询商品是否支持开增值税发票
             * end
             */

            /**
             * 查询是否厂家配送
             * start
             */
            boolean isJudgefac = isJudgefacProduct(pool.getSkuId(), cityId);

            /**
             * 查询是否厂家配送
             * end
             */
            Goods goods = null;
            boolean isExitGoods = isExistGoods(pool.getSkuId(), isJudgefac, priceResSkus);
            if (!isExitGoods) {//如果商品已经在库里面，进行更新即可，不需要新增
                goods = new Goods();
                if (!isJudgefac) {
                    goods.setJudgefac(isJudgefac);
                }
                setGoodsProperties(goods, prodDetail, imageResult.getUrls(), onShelvesList, pool, priceResSkus, isDelete);
                /**Akers 2017-08-21修改： 如果没有传入分类，尝试获取苏宁的分类 START */
                if (categoryResult == null) {
                    String catId = detailRes.getSnbody().getGetProdDetail().getCategory();
                    CategoryGetResponse cgr = snCategoryApi.getCategory(new CategoryGetRequest());
                    categoryResult = new CategoryGetResponse.ResultInfo();
                    if (cgr.getSnerror() == null) {
                        List<CategoryGetResponse.ResultInfo> snCatList = cgr.getSnbody().getGetCategory().getResultInfo();
                        for (CategoryGetResponse.ResultInfo snCat : snCatList) {
                            if (snCat.getCategoryId().equals(catId)) {
                                categoryResult = snCat;
                                break;
                            }
                        }
                    }
                }
                /**Akers 2017-08-21修改： 如果没有传入分类，尝试获取苏宁的分类 END */
                setProduct(goods, prodDetail, categoryResult, isDelete);
                goods = goodsRepos.save(goods);
                goodsId = goods.getId();
            }
        } else {
            throw new RuntimeException("同步商品详情出错【" + detailRes.getSnerror().getErrorMsg() + "】，商品编号:" + pool.getSkuId());
        }


        return goodsId;
    }

    /**
     * 是否已经在商品库里面存在
     *
     * @param skuId
     * @return
     */
    private boolean isExistGoods(String skuId, Boolean isJudgefac, PriceQueryResponse.Skus priceResSkus) {

        Boolean isExistGoods = false;
        List<Goods> goodsList = goodsRepos.findAll(new Specification() {
            @Override
            public Predicate toPredicate(Root root, CriteriaQuery query, CriteriaBuilder cb) {
                return cb.and(
                        cb.equal(root.get("sku"), skuId),
                        cb.equal(root.get("storeId"), sn_id),
                        cb.equal(root.get("code"), skuId)
                );
            }
        });

        if (!Lang.isEmpty(goodsList) && goodsList.size() > 0) {
            isExistGoods = true;
            //更新下架商品
            for (Goods goods : goodsList) {
                goods.setJudgefac(isJudgefac);
                if (!Lang.isEmpty(priceResSkus)) {
                    if (Lang.isEmpty(priceResSkus.getPrice()) || Lang.isEmpty(priceResSkus.getSnPrice())) {
                        goods.setMarketPrice(new BigDecimal(0));
                        goods.setSalePrice(new BigDecimal(0));
                        goods.setCostPrice(new BigDecimal(0));
                        goods.setDiscountRate(new BigDecimal(0));
                    } else {
                        String price = Lang.isEmpty(priceResSkus.getPrice()) ? "0" : priceResSkus.getPrice();
                        String snPrice = Lang.isEmpty(priceResSkus.getSnPrice()) ? "0" : priceResSkus.getSnPrice();
                        String discountRate = Lang.isEmpty(priceResSkus.getDiscountRate()) ? "0" : priceResSkus.getDiscountRate();
                        if (Lang.isEmpty(snPrice) && !Lang.isEmpty(price)) {
                            snPrice = price;
                        }
                        goods.setMarketPrice(new BigDecimal(snPrice));
                        goods.setSalePrice(new BigDecimal(price).multiply(new BigDecimal(discountRate)));
                        goods.setCostPrice(new BigDecimal(price));
                        goods.setDiscountRate(new BigDecimal(discountRate));
                    }
                } else {
                    //苏宁默认未0
                    goods.setMarketPrice(new BigDecimal(0));
                    goods.setSalePrice(new BigDecimal(0));
                    goods.setCostPrice(new BigDecimal(0));
                    goods.setDiscountRate(new BigDecimal(0));
                }
                goodsRepos.save(goods);
            }
        }

        return isExistGoods;
    }

    /**
     * 查询是否厂家配送
     *
     * @param skuId
     * @param cityId
     * @return
     */
    private boolean isJudgefacProduct(String skuId, String cityId) {
        Boolean isJudgefac = true;
        JudgefacproductGetRequest request = new JudgefacproductGetRequest();
        request.setCityId(cityId);
        JudgefacproductGetRequest.SkuIds skuIds = new JudgefacproductGetRequest.SkuIds();
        skuIds.setSkuId(skuId);
        request.setSkuIds(Arrays.asList(skuIds));
        JudgefacproductGetResponse getJudgefacProduct = snProductApi.getJudgefacProduct(request);
        if (!Lang.isEmpty(getJudgefacProduct) && !Lang.isEmpty(getJudgefacProduct.getSnbody()) && !Lang.isEmpty(getJudgefacProduct.getSnbody().getGetJudgefacproduct())) {
            if (!Lang.isEmpty(getJudgefacProduct.getSnbody().getGetJudgefacproduct().getIsSuccess())) {
                if (getJudgefacProduct.getSnbody().getGetJudgefacproduct().getIsSuccess().equals("Y")) {
                    if (getJudgefacProduct.getSnbody().getGetJudgefacproduct().getResults().get(0).getIsFactorySend().equals("02")) {//是否厂送商品 01-是；02-否 当isSuccess=Y时必填
                        isJudgefac = false;
                    }
                }
            }
        }

        return isJudgefac;
    }

    private Goods setGoodsProperties(Goods goods, ProdDetailGetResponse.GetProdDetail productDetail, List<ProdImageQueryResponse.Urls> imageResult, BatchProdSaleStatusGetResponse.OnShelvesList onShelvesList, ProdPoolQueryResponse.ResultInfo pool, PriceQueryResponse.Skus priceResSkus, Boolean isDelete) {
        goods.setName(productDetail.getName());
        goods.setStoreId(sn_id);

        if (!Lang.isEmpty(priceResSkus)) {
            if (Lang.isEmpty(priceResSkus.getPrice()) || Lang.isEmpty(priceResSkus.getSnPrice())) {
                isDelete = true;
                goods.setMarketPrice(new BigDecimal(0));
                goods.setSalePrice(new BigDecimal(0));
                goods.setCostPrice(new BigDecimal(0));
                goods.setDiscountRate(new BigDecimal(0));
            } else {
                String price = Lang.isEmpty(priceResSkus.getPrice()) ? "0" : priceResSkus.getPrice();
                String snPrice = Lang.isEmpty(priceResSkus.getSnPrice()) ? "0" : priceResSkus.getSnPrice();
                String discountRate = Lang.isEmpty(priceResSkus.getDiscountRate()) ? "0" : priceResSkus.getDiscountRate();
                if (Lang.isEmpty(snPrice) && !Lang.isEmpty(price)) {
                    snPrice = price;
                }
                goods.setMarketPrice(new BigDecimal(snPrice));
                goods.setSalePrice(new BigDecimal(price).multiply(new BigDecimal(discountRate)));
                goods.setCostPrice(new BigDecimal(price));
                goods.setDiscountRate(new BigDecimal(discountRate));
            }
        } else {
            //苏宁默认未0
            goods.setMarketPrice(new BigDecimal(0));
            goods.setSalePrice(new BigDecimal(0));
            goods.setCostPrice(new BigDecimal(0));
            goods.setDiscountRate(new BigDecimal(0));
        }
        /*if(Lang.isEmpty(priceSkus.getDiscountRate())){
            goods.setDiscountRate(new BigDecimal(1.0));
        }else{
            goods.setDiscountRate(new BigDecimal(priceSkus.getDiscountRate()));
        }
        goods.setMarketPrice(new BigDecimal(priceSkus.getPrice()));
        goods.setSalePrice(new BigDecimal(priceSkus.getSnPrice()));
        BigDecimal salePrice = goods.getSalePrice();
        goods.setCostPrice(salePrice.multiply(goods.getDiscountRate()));*/
        goods.setBrandName(productDetail.getBrand());
        goods.setIntroduction(productDetail.getIntroduction());

        //goods.setParam(productDetail.getParam());
        goods.setProductArea(productDetail.getProductArea());
        goods.setSaleUnit(productDetail.getSaleUnit());
        goods.setSku(productDetail.getSkuId() + "");
        goods.setCode(productDetail.getSkuId() + "");
        goods.setState(Integer.valueOf(productDetail.getState()));
        goods.setUpc(productDetail.getUpc());
        //goods.setWareQD(productDetail.getWareQD());
        goods.setWeight(productDetail.getWeight());
        goods.setPushUpDate(new Date());

        List<GoodsAttr> goodsAttrs = new ArrayList<GoodsAttr>();
        GoodsAttr goodsTyep = new GoodsAttr();
        goodsTyep.setGoods(goods);
        goodsTyep.setAttrName("商品类型");
        goodsTyep.setAttrValue(pool.getCmmdtyType());
        goodsAttrs.add(goodsTyep);

        if (!Lang.isEmpty(pool.getGeneralSku())) {
            GoodsAttr generalSku = new GoodsAttr();
            generalSku.setGoods(goods);
            goodsTyep.setAttrName("通码");
            goodsTyep.setAttrValue(pool.getGeneralSku());
            goodsAttrs.add(generalSku);
        }

        goods.setGoodsAttrs(goodsAttrs);

        List<GoodsParams> goodsParamses = new ArrayList<GoodsParams>();
        if (!Lang.isEmpty(productDetail.getProdParams())) {
            for (ProdDetailGetResponse.ProdParams prodParams : productDetail.getProdParams()) {
                for (ProdDetailGetResponse.Param param : prodParams.getParam()) {
                    GoodsParams goodsParams = new GoodsParams();
                    goodsParams.setParamDesc(prodParams.getDesc());
                    goodsParams.setCoreFlag(param.getCoreFlag());
                    goodsParams.setCategory(productDetail.getCategory());
                    goodsParams.setGoods(goods);
                    goodsParams.setSnparameterVal(param.getSnparameterVal());
                    goodsParams.setSnparameterCode(param.getSnparameterCode());
                    goodsParams.setSnsequence(param.getSnsequence());
                    goodsParams.setSnparameterdesc(param.getSnparameterdesc());
                    goodsParams.setSnparametersCode(param.getSnparametersCode());
                    goodsParams.setSnparametersDesc(param.getSnparametersDesc());
                    goodsParams.setSnparameterSequence(param.getSnparameterSequence());
                    goodsParamses.add(goodsParams);
                }
            }

            goods.setGoodsParams(goodsParamses);
        }
        List<GoodsPicture> goodsPictures = new ArrayList<GoodsPicture>();
        int i = 0;
        for (ProdImageQueryResponse.Urls urls : imageResult) {
            GoodsPicture goodsPicture = new GoodsPicture();
            goodsPicture.setPicturePath(urls.getPath());
            goodsPicture.setBigPicturePath(urls.getPath());
            if ("1".equals(urls.getPrimary())) {
                goodsPicture.setShowIndex(0);
            } else {
                i++;
                goodsPicture.setShowIndex(i);
            }
            if (isDelete) {
                goodsPicture.setIsDelete(isDelete);
            }
            //保存关联
            goodsPicture.setGoods(goods);
            goodsPictures.add(goodsPicture);
        }
        if (isDelete) {
            goods.setIsDelete(isDelete);
        }
        goods.setGoodsPictures(goodsPictures);
        return goods;
    }

    public Goods setProduct(Goods goods, ProdDetailGetResponse.GetProdDetail productDetail, CategoryGetResponse.ResultInfo categoryResult, Boolean isDelete) {
        //product
        Product product = new Product();
        product.setGoodses(Arrays.asList(goods));
        // 苏宁默认未0
        String productName = goods.getName();
        product.setCostPrice(goods.getCostPrice());
        product.setMarketPrice(goods.getMarketPrice());
        product.setSalePrice(goods.getSalePrice());
        product.setProductName(productName);
        product.setTitle(productName);
        product.setCode(goods.getSku());
        product.setStoreId(sn_id);
        //productFashion
        ProductFashion productFashion = new ProductFashion();
        // 苏宁默认未0
        productFashion.setCostPrice(goods.getCostPrice());
        product.setMarketPrice(goods.getMarketPrice());
        product.setSalePrice(goods.getSalePrice());
        productFashion.setProductCode(goods.getSku());
        productFashion.setStockCount(goods.getStockCount().intValue());
        productFashion.setLackRemind(0);//庫存預警 默認10 2017-01-11: 暂不控制库存预警，默认值设为0
        productFashion.setOnSale(true);//是否在销
        if (!Lang.isEmpty(goods.getGoodsPictures())) {
            productFashion.setFashionPic(goods.getGoodsPictures().get(0).getPicturePath());//圖片
        }
        productFashion.setFashionTitle(productName);
        /**
         * 写死数据
         */
        productFashion.setFieldName("型号");
        productFashion.setFieldType("1");
        productFashion.setValue(productDetail.getModel());
        productFashion.setValueName(productDetail.getModel());
        /**
         * 写死数据
         */
        //设置双向关联
        if (isDelete) {
            productFashion.setIsDelete(isDelete);
        }
        productFashion.setProduct(product);
        product.setProductFashions(Arrays.asList(productFashion));

        ProductFashionPicture fashionPic = null;
        List<ProductFashionPicture> productFashionPictures = new ArrayList<>();
        boolean hasDefault = false;
        for (GoodsPicture gp : goods.getGoodsPictures()) {
            fashionPic = new ProductFashionPicture();
            fashionPic.setProductFashion(productFashion);
            fashionPic.setAppPicturePath(gp.getAppPicturePath());
            fashionPic.setBigPicturePath(gp.getBigPicturePath());
            fashionPic.setPicturePath(gp.getPicturePath());
            fashionPic.setShowIndex(gp.getShowIndex());
            if (!hasDefault && (gp.getShowIndex() == 0 || goods.getGoodsPictures().size() == 1)) {
                fashionPic.setDefaultFlag(true);
                hasDefault = true;
            }
            productFashionPictures.add(fashionPic);
        }
        productFashion.setProductFashionPictures(productFashionPictures);


        //productCategory

        //设置品牌信息
        ProductBrand productBrand = setBrand(productDetail.getBrand());


        ProductCategory productCategory = null;
        String categoryName = "";
        if (!Lang.isEmpty(categoryResult)) {
            /**
             * 苏宁分类，默认从三级开始控制
             */
            categoryName = categoryResult.getCategoryName();
            TestMatchCategoryData testMatchCategoryData = tMCDRepo.findBySnThreeCat(categoryName);
            String dateStr = "2017-04-11 9:38:51";
            productCategory = gennerProductCategory(testMatchCategoryData, testMatchCategoryData.getJdThreeCat(), 3, dateStr);
        }


        // String productCategoryId = "";
        if (Lang.isEmpty(productCategory)) {
            //查询不到，将数据新增，然后将分类信息记录下来，人工维护
            productCategory = new ProductCategory();
            productCategory.setLayerIndex(1);//设置为一级
            productCategory.setSourceCode(sn_code);
            productCategory.setName(categoryName);
            //productCategoryRepos.save(productCategory);
            log.info("查询不到，将数据新增，然后将分类信息记录下来，人工维护;分类名称：" + categoryName);
        }

        if (!Lang.isEmpty(productBrand) && !Lang.isEmpty(productCategory)) {
            Integer count = (Integer) jdbcTemplate.queryForObject(countSql, new Object[]{productBrand.getId(), productCategory.getId()}, Integer.class);
            if (Lang.isEmpty(count) || count == 0) {
                List<ProductBrand> productBrands = new ArrayList<>();
                productBrands.add(productBrand);
                productCategory.setProductBrands(productBrands);
                productCategoryRepos.save(productCategory);
            }
        }
        product.setProductCategory(productCategory);

        if (isDelete) {
            product.setIsDelete(isDelete);
        }
        //product =productRepos.save(product);
        if (!Lang.isEmpty(productCategory)) {
            goods.setProduct(product);
        }
        productRepos.save(product);
        return goods;
    }


    public ProductCategory gennerProductCategory(TestMatchCategoryData testMatchCategoryData, String name, Integer layerIndex, String dateStr) {
        ProductCategory returnProductCategory = null;
        List<ProductCategory> productCategorys = productCategoryRepos.findAll(new Specification() {
            @Override
            public Predicate toPredicate(Root root, CriteriaQuery query, CriteriaBuilder cb) {
                return cb.and(
                        cb.equal(root.get("name"), name),
                        cb.equal(root.get("layerIndex"), layerIndex),
                        //  cb.equal(root.get("isDelete"),false),
                        cb.equal(root.get("sourceCode"), "jingdong"),
                        cb.greaterThanOrEqualTo(root.<Date>get("dateCreated"), DateUtils.toDate(dateStr, GlobalContants.DateFormat.YYYY_MM_DD_HH_MM_SS))

                );
            }
        });
        for (ProductCategory productCategory : productCategorys) {
            if (!Lang.isEmpty(productCategory.getParent()) && !Lang.isEmpty(productCategory.getParent().getParent())) {
                if (productCategory.getParent().getName().equals(testMatchCategoryData.getJdTwoCat()) && productCategory.getParent().getParent().getName().equals(testMatchCategoryData.getJdOneCat())) {
                    returnProductCategory = productCategory;
                }
            }
        }
        return returnProductCategory;
    }

//    public static void main(String[] agrs){
//        System.out.println(DateUtils.dateToStr(DateUtils.toDate("2017-04-11 9:38:51", GlobalContants.DateFormat.YYYY_MM_DD_HH_MM_SS)));
//    }

    private ProductBrand setBrand(String brandName) {
        if (Lang.isEmpty(brandName)) {//如果品牌名称为空，需要将品牌数据设置默认
            brandName = "没有品牌的商品" + sn_code;
        }
        List<ProductBrand> productBrands = productBrandRepos.findByNameAndIsDelete(brandName, false);
        ProductBrand productBrand = null;
        if (Lang.isEmpty(productBrands) && productBrands.size() <= 0) {
            productBrand = new ProductBrand();
            String websitesUrl = "www.suning.com";//官网地址
            String BRAND_NAME = brandName;
            productBrand.setShowIndex(1);
            productBrand.setDescription(BRAND_NAME);
            productBrand.setName(BRAND_NAME);
            productBrand.setSimpleName(BRAND_NAME);
            productBrand.setWebsitesUrl(websitesUrl);
            productBrand.setSourceCode(sn_code);
            productBrandRepos.save(productBrand);
        } else {
            productBrand = productBrands.get(0);
        }
        return productBrand;

    }

    public void deleteAllSnGoods() {
        Goods goods = new Goods();
        goods.setStoreId(sn_id);
        List<Goods> goodsList = goodsRepos.findAll(Example.of(goods));

        ProductCategory productCategory = new ProductCategory();
        productCategory.setTplChannel(sn_id);
        List<ProductCategory> productCategoryList = productCategoryRepos.findAll(Example.of(productCategory));

        goodsRepos.delete(goodsList);
        goodsRepos.flush();
        productCategoryRepos.delete(productCategoryList);
        productCategoryRepos.flush();
    }

    private static final String countSql = "SELECT count(*) FROM product_category_brand  where brand_id = ?  and category_id =? ";

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    ProductBrandRepos productBrandRepos;

}
