package provider.api.gateway.business.good.service;

import goods.dto.product.CategoryQueryDto;
import pool.dto.*;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 *
 * @author wangtao
 * @date 2018-7-1
 */
public interface ProviderGoodsService {
    BaseResponse categories( CategoryQueryDto categoryDto);
    BaseResponse createBrands(BrandDto brandDto);
    BaseResponse brands(BrandQueryDto brandQueryDto);
    BaseResponse deleteBrands(String brandId);

    BaseResponse getModels(ProductModelQueryDto productModelQueryDto);
    BaseResponse createModels( ProductModelDto productModelDto);
    BaseResponse modifyModels( ProductModelDto productModelDto);
    BaseResponse deleteModels( String modelSku, String storeId);

    BaseResponse products(ProductQueryDto productQueryDto);
    BaseResponse product( String sku, String storeId);
    BaseResponse createProduct( ProviderGoodsDto providerGoodsDto);
    BaseResponse updateProviderProduct(ProviderGoodsDto providerGoodsDto);

    BaseResponse modifyProductStatus(List<ProviderGoodsStatus> providerGoodsStatusList, String storeId);
    BaseResponse modifyProductPrice(List<ProviderGoodsPrice> providerGoodsPriceList, String storeId);
    BaseResponse modifyProductStock(List<ProviderGoodsStock> providerGoodsStockList, String storeId);
}
