package provider.api.gateway.business.order.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import provider.api.gateway.business.order.service.TestMessageService;
import provider.api.gateway.business.order.vo.SubOrderVo;
import provider.api.gateway.business.order.vo.TestResponseVo;
import provider.api.gateway.filter.ProviderRequestInfoWrapper;
import provider.api.gateway.util.ProviderInfoUtil;
import provider.api.gateway.vo.BusinessResponseVo;
import provider.api.gateway.vo.OauthInfoVo;

import javax.servlet.http.HttpServletRequest;

/**
 * @author torvalds on 2018/6/27 14:43.
 * @version 1.0
 */
@RestController
@RequestMapping("orderTest")
public class TestController {
    @Autowired
    TestMessageService testMessageService;

    @RequestMapping("message")
    public BusinessResponseVo<TestResponseVo> messageApiTest(HttpServletRequest request, @RequestBody SubOrderVo subOrderVo) {
        OauthInfoVo providerInfo = ProviderInfoUtil.getProviderInfo(request);
        String providerId = providerInfo.getProviderId();
        String appId = providerInfo.getAppId();
        BusinessResponseVo<TestResponseVo> businessResponseVo = new BusinessResponseVo<>();
        String message = "I am test Message";
        TestResponseVo testResponseVo = testMessageService.testMessage(message);
        businessResponseVo.setResult(testResponseVo);
        return businessResponseVo;
    }
}
