/*
 * Decompiled with CFR 0.152.
 */
package provider.api.gateway.business.good.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import pool.dto.requestParamsEntry.AddressParamsQueryDto;
import provider.api.gateway.business.good.service.ProviderAddressApiService;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

@RestController
public class ProviderAddressController {
    private static final Logger logger = LoggerFactory.getLogger(ProviderAddressController.class);
    @Autowired
    private ProviderAddressApiService providerAddressApiService;

    @PostMapping(value={"/get/address/province"})
    public BaseResponse getProvinces() {
        logger.info("query province.");
        return this.providerAddressApiService.getProvinces();
    }

    @PostMapping(value={"/get/address/city"})
    public BaseResponse getCitys(@RequestBody AddressParamsQueryDto addressParamsQueryDto) {
        logger.info("query city.");
        if (Lang.isEmpty((Object)addressParamsQueryDto)) {
            return null;
        }
        return this.providerAddressApiService.getCitys(addressParamsQueryDto.getProvince_id());
    }

    @PostMapping(value={"/get/address/county"})
    public BaseResponse getCountys(@RequestBody AddressParamsQueryDto addressParamsQueryDto) {
        logger.info("query county,parentId");
        if (Lang.isEmpty((Object)addressParamsQueryDto)) {
            return null;
        }
        return this.providerAddressApiService.getCountys(addressParamsQueryDto.getCity_id());
    }

    @PostMapping(value={"/get/address/town"})
    public BaseResponse getTowns(@RequestBody AddressParamsQueryDto addressParamsQueryDto) {
        logger.info("query town.");
        if (Lang.isEmpty((Object)addressParamsQueryDto)) {
            return null;
        }
        return this.providerAddressApiService.getTowns(addressParamsQueryDto.getCounty_id());
    }
}

