/*
 * Decompiled with CFR 0.152.
 */
package provider.api.gateway.business.good.controller;

import goods.dto.product.CategoryQueryDto;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import pool.dto.BrandDto;
import pool.dto.BrandQueryDto;
import pool.dto.ProductModelDto;
import pool.dto.ProductModelQueryDto;
import pool.dto.ProductQueryDto;
import pool.dto.ProviderGoodsDto;
import pool.dto.requestParamsEntry.BrandDeleteQueryDto;
import pool.dto.requestParamsEntry.ModelDeleteQueryDto;
import pool.dto.requestParamsEntry.ProductSingleQueryDto;
import pool.dto.requestParamsEntry.UpdateProductPriceRequestVo;
import pool.dto.requestParamsEntry.UpdateProductStatusRequestVo;
import pool.dto.requestParamsEntry.UpdateProductStockRequestVo;
import provider.api.gateway.business.good.service.ProviderGoodsService;
import provider.api.gateway.util.ProviderInfoUtil;
import provider.api.gateway.vo.OauthInfoVo;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

@RestController
public class ProviderGoodsController {
    private static final Logger logger = LoggerFactory.getLogger(ProviderGoodsController.class);
    @Autowired
    private ProviderGoodsService providerGoodsService;

    @RequestMapping(value={"test"}, method={RequestMethod.GET})
    public void test() {
        logger.info("this is a test method.");
    }

    @RequestMapping(value={"/get/categories"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse categories(@RequestBody CategoryQueryDto categoryDto) {
        logger.info("query categories.");
        return this.providerGoodsService.categories(categoryDto);
    }

    @RequestMapping(value={"/create/brands"}, method={RequestMethod.POST})
    public BaseResponse createBrands(@RequestBody BrandDto brandDto, HttpServletRequest request) {
        logger.info("create brands.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo((HttpServletRequest)request);
        if (Lang.isEmpty((Object)oauthInfoVo)) {
            return new BaseResponse(false, "accessToken\u9519\u8bef", (Object)"", "110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        brandDto.setStoreId(storeId);
        return this.providerGoodsService.createBrands(brandDto);
    }

    @RequestMapping(value={"/get/brands"}, method={RequestMethod.POST})
    public BaseResponse brands(@RequestBody BrandQueryDto brandQueryDto, HttpServletRequest request) {
        logger.info("query brands.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo((HttpServletRequest)request);
        if (Lang.isEmpty((Object)oauthInfoVo)) {
            return new BaseResponse(false, "accessToken\u9519\u8bef", (Object)"", "110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        brandQueryDto.setStoreId(storeId);
        return this.providerGoodsService.brands(brandQueryDto);
    }

    @RequestMapping(value={"/delete/brands"}, method={RequestMethod.POST})
    public BaseResponse deleteBrands(@RequestBody BrandDeleteQueryDto brandDeleteQueryDto) {
        logger.info("delete brands.");
        if (Lang.isEmpty((Object)brandDeleteQueryDto)) {
            return new BaseResponse(false, "accessToken\u9519\u8bef", (Object)"", "110012");
        }
        return this.providerGoodsService.deleteBrands(brandDeleteQueryDto.getBrandId());
    }

    @RequestMapping(value={"/get/models"}, method={RequestMethod.POST})
    public BaseResponse getModels(@RequestBody ProductModelQueryDto productModelQueryDto, HttpServletRequest request) {
        logger.info("get models.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo((HttpServletRequest)request);
        if (Lang.isEmpty((Object)oauthInfoVo)) {
            return new BaseResponse(false, "accessToken\u9519\u8bef", (Object)"", "110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        productModelQueryDto.setStoreId(storeId);
        return this.providerGoodsService.getModels(productModelQueryDto);
    }

    @RequestMapping(value={"/create/models"}, method={RequestMethod.POST})
    public BaseResponse createModels(@RequestBody ProductModelDto productModelDto, HttpServletRequest request) {
        logger.info("create model.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo((HttpServletRequest)request);
        if (Lang.isEmpty((Object)oauthInfoVo)) {
            return new BaseResponse(false, "accessToken\u9519\u8bef", (Object)"", "110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        productModelDto.setStoreId(storeId);
        return this.providerGoodsService.createModels(productModelDto);
    }

    @RequestMapping(value={"/modify/models"}, method={RequestMethod.POST})
    public BaseResponse modifyModels(@RequestBody ProductModelDto productModelDto, HttpServletRequest request) {
        logger.info("modify model.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo((HttpServletRequest)request);
        if (Lang.isEmpty((Object)oauthInfoVo)) {
            return new BaseResponse(false, "accessToken\u9519\u8bef", (Object)"", "110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        productModelDto.setStoreId(storeId);
        return this.providerGoodsService.modifyModels(productModelDto);
    }

    @RequestMapping(value={"/delete/models"}, method={RequestMethod.POST})
    public BaseResponse deleteModels(@RequestBody ModelDeleteQueryDto modelDeleteQueryDto, HttpServletRequest request) {
        logger.info("delete model.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo((HttpServletRequest)request);
        if (Lang.isEmpty((Object)oauthInfoVo)) {
            return new BaseResponse(false, "accessToken\u9519\u8bef", (Object)"", "110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        modelDeleteQueryDto.setStoreId(storeId);
        return this.providerGoodsService.deleteModels(modelDeleteQueryDto.getModelSku(), modelDeleteQueryDto.getStoreId());
    }

    @RequestMapping(value={"/get/products"}, method={RequestMethod.POST})
    public BaseResponse products(@RequestBody ProductQueryDto productQueryDto, HttpServletRequest request) {
        logger.info("query products.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo((HttpServletRequest)request);
        if (Lang.isEmpty((Object)oauthInfoVo)) {
            return new BaseResponse(false, "accessToken\u9519\u8bef", (Object)"", "110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        productQueryDto.setStoreId(storeId);
        return this.providerGoodsService.products(productQueryDto);
    }

    @RequestMapping(value={"/get/product"}, method={RequestMethod.POST})
    public BaseResponse product(@RequestBody ProductSingleQueryDto productSingleQueryDto, HttpServletRequest request) {
        logger.info("query product.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo((HttpServletRequest)request);
        if (Lang.isEmpty((Object)oauthInfoVo)) {
            return new BaseResponse(false, "accessToken\u9519\u8bef", (Object)"", "110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        productSingleQueryDto.setStoreId(storeId);
        return this.providerGoodsService.product(productSingleQueryDto.getSku(), storeId);
    }

    @RequestMapping(value={"/create/product"}, method={RequestMethod.POST})
    public BaseResponse createProduct(@RequestBody ProviderGoodsDto providerGoodsDto, HttpServletRequest request) {
        logger.info("create product.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo((HttpServletRequest)request);
        if (Lang.isEmpty((Object)oauthInfoVo)) {
            return new BaseResponse(false, "accessToken\u9519\u8bef", (Object)"", "110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        providerGoodsDto.setStoreId(storeId);
        return this.providerGoodsService.createProduct(providerGoodsDto);
    }

    @RequestMapping(value={"/modify/product"}, method={RequestMethod.POST})
    public BaseResponse updateProviderProduct(@RequestBody ProviderGoodsDto providerGoodsDto, HttpServletRequest request) {
        logger.info("modify product.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo((HttpServletRequest)request);
        if (Lang.isEmpty((Object)oauthInfoVo)) {
            return new BaseResponse(false, "accessToken\u9519\u8bef", (Object)"", "110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        providerGoodsDto.setStoreId(storeId);
        return this.providerGoodsService.updateProviderProduct(providerGoodsDto);
    }

    @RequestMapping(value={"modify/products/status"}, method={RequestMethod.POST})
    public BaseResponse modifyProductStatus(@RequestBody UpdateProductStatusRequestVo updateProductStatusRequestVo, HttpServletRequest request) {
        logger.info("modify productStatus.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo((HttpServletRequest)request);
        if (Lang.isEmpty((Object)oauthInfoVo)) {
            return new BaseResponse(false, "accessToken\u9519\u8bef", (Object)"", "110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        if (Lang.isEmpty((Object)updateProductStatusRequestVo) || Lang.isEmpty((Object)updateProductStatusRequestVo.getUpdownStatus()) || updateProductStatusRequestVo.getUpdownStatus().size() == 0) {
            return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570\u7f3a\u5931", (Object)"", "3001");
        }
        return this.providerGoodsService.modifyProductStatus(updateProductStatusRequestVo.getUpdownStatus(), storeId);
    }

    @RequestMapping(value={"modify/products/price"}, method={RequestMethod.POST})
    public BaseResponse modifyProductPrice(@RequestBody UpdateProductPriceRequestVo updateProductPriceRequestVo, HttpServletRequest request) {
        logger.info("modify productPrice.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo((HttpServletRequest)request);
        if (Lang.isEmpty((Object)oauthInfoVo)) {
            return new BaseResponse(false, "accessToken\u9519\u8bef", (Object)"", "110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        if (Lang.isEmpty((Object)updateProductPriceRequestVo) || Lang.isEmpty((Object)updateProductPriceRequestVo.getPrices()) || updateProductPriceRequestVo.getPrices().size() == 0) {
            return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570\u7f3a\u5931", (Object)"", "3001");
        }
        return this.providerGoodsService.modifyProductPrice(updateProductPriceRequestVo.getPrices(), storeId);
    }

    @RequestMapping(value={"modify/products/stock"}, method={RequestMethod.POST})
    public BaseResponse modifyProductStock(@RequestBody UpdateProductStockRequestVo updateProductStockRequestVo, HttpServletRequest request) {
        logger.info("modify productStock.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo((HttpServletRequest)request);
        if (Lang.isEmpty((Object)oauthInfoVo)) {
            return new BaseResponse(false, "accessToken\u9519\u8bef", (Object)"", "110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        if (Lang.isEmpty((Object)updateProductStockRequestVo) || Lang.isEmpty((Object)updateProductStockRequestVo.getStocks()) || updateProductStockRequestVo.getStocks().size() == 0) {
            return new BaseResponse(false, "\u8bf7\u6c42\u53c2\u6570\u7f3a\u5931", (Object)"", "3001");
        }
        return this.providerGoodsService.modifyProductStock(updateProductStockRequestVo.getStocks(), storeId);
    }
}

