/*
 * Decompiled with CFR 0.152.
 */
package provider.api.gateway.business.message.controller;

import com.alibaba.fastjson.JSON;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import provider.api.gateway.business.message.service.ProviderMessageService;
import provider.api.gateway.business.message.vo.TypeVo;
import provider.api.gateway.util.ProviderInfoUtil;
import provider.api.gateway.vo.OauthInfoVo;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

@RestController
@RequestMapping(value={"/"})
public class ProviderMessageController {
    @Autowired
    private ProviderMessageService providerMessageService;
    public static Logger logger = LoggerFactory.getLogger(ProviderMessageController.class);

    @RequestMapping(value={"/delete/messages"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse deleteMessages(@RequestBody List<String> ids, HttpServletRequest request) {
        OauthInfoVo providerInfo = ProviderInfoUtil.getProviderInfo((HttpServletRequest)request);
        String appId = providerInfo.getAppId();
        String providerId = providerInfo.getProviderId();
        logger.info("request  appId is {} and providerId is {} and ids is {}", new Object[]{appId, providerId, JSON.toJSONString(ids)});
        BaseResponse baseResponse = this.providerMessageService.deleteByIdsAndProviderId(ids, providerId);
        return baseResponse;
    }

    @RequestMapping(value={"/get/messages"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse getMessages(@RequestBody TypeVo type, HttpServletRequest request) {
        if (Lang.isEmpty((Object)type)) {
            return new BaseResponse(false, "\u53c2\u6570\u9519\u8bef");
        }
        OauthInfoVo providerInfo = ProviderInfoUtil.getProviderInfo((HttpServletRequest)request);
        String appId = providerInfo.getAppId();
        String providerId = providerInfo.getProviderId();
        logger.info("request  appId is {} and providerId is {} and type is {}", new Object[]{appId, providerId, JSON.toJSONString((Object)type)});
        BaseResponse baseResponse = this.providerMessageService.getMessagesByTypeAndProvider(type.getType(), providerId);
        return baseResponse;
    }
}

