/*
 * Decompiled with CFR 0.152.
 */
package provider.api.gateway.business.order.controller;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import provider.api.gateway.business.order.service.ProviderOrderService;
import provider.api.gateway.business.order.vo.LogisticsVo;
import provider.api.gateway.business.order.vo.OrderNoVo;
import provider.api.gateway.business.order.vo.SubOrderNoVo;
import provider.api.gateway.util.ProviderInfoUtil;
import provider.api.gateway.vo.OauthInfoVo;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

@RestController
@RequestMapping(value={"/"})
public class ProviderOrderController {
    @Autowired
    private ProviderOrderService providerOrderService;
    public static Logger logger = LoggerFactory.getLogger(ProviderOrderController.class);

    @RequestMapping(value={"/get/order"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse getOrder(@RequestBody OrderNoVo orderNo, HttpServletRequest request) {
        logger.info("------------------------getOrderContollerBegin");
        if (Lang.isEmpty((Object)orderNo)) {
            return new BaseResponse(false, "\u53c2\u6570\u9519\u8bef", (Object)"3001");
        }
        OauthInfoVo providerInfo = ProviderInfoUtil.getProviderInfo((HttpServletRequest)request);
        String providerId = providerInfo.getProviderId();
        if (Lang.isEmpty((Object)providerId)) {
            return new BaseResponse(false, "\u53c2\u6570\u9519\u8bef", (Object)"3001");
        }
        BaseResponse baseResponse = this.providerOrderService.getOrderDetailByOrderNo(orderNo.getOrderNo(), providerId);
        return baseResponse;
    }

    @RequestMapping(value={"/modify/orders/logistics"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse setOrderLogistics(@RequestBody LogisticsVo logisticsVo, HttpServletRequest request) {
        if (Lang.isEmpty((Object)logisticsVo)) {
            return new BaseResponse(false, "\u53c2\u6570\u9519\u8bef", (Object)"3001");
        }
        String orderNo = logisticsVo.getOrderNo();
        List subOrderVos = logisticsVo.getSubOrders();
        OauthInfoVo providerInfo = ProviderInfoUtil.getProviderInfo((HttpServletRequest)request);
        String providerId = providerInfo.getProviderId();
        if (Lang.isEmpty((Object)providerId)) {
            return new BaseResponse(false, "\u53c2\u6570\u9519\u8bef", (Object)"3001");
        }
        BaseResponse baseResponse = this.providerOrderService.setOrderLogistics(orderNo, subOrderVos, providerId);
        return baseResponse;
    }

    @RequestMapping(value={"/modify/orders/received"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse setSubOrderReceived(@RequestBody SubOrderNoVo subOrderNo, HttpServletRequest request) {
        if (Lang.isEmpty((Object)subOrderNo)) {
            return new BaseResponse(false, "\u53c2\u6570\u9519\u8bef", (Object)"3001");
        }
        OauthInfoVo providerInfo = ProviderInfoUtil.getProviderInfo((HttpServletRequest)request);
        String providerId = providerInfo.getProviderId();
        if (Lang.isEmpty((Object)providerId)) {
            return new BaseResponse(false, "\u53c2\u6570\u9519\u8bef", (Object)"3001");
        }
        BaseResponse baseResponse = this.providerOrderService.setSubOrderAccepted(subOrderNo.getSubOrderNo(), providerId);
        return baseResponse;
    }

    @RequestMapping(value={"/modify/rejected/orders"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse setSubOrderRejected(@RequestBody SubOrderNoVo subOrderNo, HttpServletRequest request) {
        if (Lang.isEmpty((Object)subOrderNo)) {
            return new BaseResponse(false, "\u53c2\u6570\u9519\u8bef", (Object)"3001");
        }
        OauthInfoVo providerInfo = ProviderInfoUtil.getProviderInfo((HttpServletRequest)request);
        String providerId = providerInfo.getProviderId();
        if (Lang.isEmpty((Object)providerId)) {
            return new BaseResponse(false, "\u53c2\u6570\u9519\u8bef", (Object)"3001");
        }
        BaseResponse baseResponse = this.providerOrderService.setSubOrderRejected(subOrderNo.getSubOrderNo(), providerId);
        return baseResponse;
    }
}

