/*
 * Decompiled with CFR 0.152.
 */
package provider.api.gateway.business.order.service.impl;

import cart.api.OrderMainApi;
import cart.api.SubOrderApi;
import cart.api.TrdSpOrderStatusApi;
import cart.api.difinication.TrdSpOrderStatus;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import cart.api.dto.order.SubOrderDto;
import cart.api.dto.order.SubOrderItemDto;
import cart.api.exception.BusinessException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.ArrayList;
import java.util.List;
import member.api.MemberAddressApi;
import member.api.dto.shop.MemberAddressDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import provider.api.gateway.business.order.service.ProviderOrderService;
import provider.api.gateway.business.order.vo.MemberAddressVo;
import provider.api.gateway.business.order.vo.OrderItemVo;
import provider.api.gateway.business.order.vo.OrderVo;
import provider.api.gateway.business.order.vo.SubOrderItemVo;
import provider.api.gateway.business.order.vo.SubOrderVo;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

@Service
public class ProviderOrderServiceImpl
implements ProviderOrderService {
    @MotanReferer
    private OrderMainApi orderMainApi;
    @MotanReferer
    private MemberAddressApi memberAddressApi;
    @MotanReferer
    private SubOrderApi subOrderApi;
    @MotanReferer
    private TrdSpOrderStatusApi trdSpOrderStatusApi;
    public static Logger logger = LoggerFactory.getLogger(ProviderOrderServiceImpl.class);

    public BaseResponse getOrderDetailByOrderNo(String orderNo, String providerId) {
        if (Lang.isEmpty((Object)orderNo)) {
            return new BaseResponse(false, "\u53c2\u6570\u9519\u8bef", null, "3001");
        }
        logger.info("=====================\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u63a5\u53e3\u88ab\u8c03\u7528\uff0c\u5bf9\u65b9\u8bf7\u6c42\u53c2\u6570orderNo:{},providerId{})", (Object)orderNo, (Object)providerId);
        OrderMainDto orderMainDto = this.orderMainApi.findByOrderNoAndProviderId(orderNo, providerId);
        if (Lang.isEmpty((Object)orderMainDto)) {
            return new BaseResponse(false, "\u672a\u627e\u5230\u4e3b\u8ba2\u5355", null, "4006");
        }
        List orderItemDtos = new ArrayList();
        String AddressId = "";
        MemberAddressDto memberAddressDto = new MemberAddressDto();
        MemberAddressVo memberAddressVo = new MemberAddressVo();
        OrderVo orderVo = new OrderVo();
        orderItemDtos = orderMainDto.getOrderItems();
        ArrayList<OrderItemVo> orderItemVos = new ArrayList<OrderItemVo>();
        OrderItemVo tempItemVo = new OrderItemVo();
        for (OrderItemDto orderItem : orderItemDtos) {
            tempItemVo.setSku(orderItem.getSku());
            tempItemVo.setCostPrice(orderItem.getCostPrice());
            tempItemVo.setCount(orderItem.getCount());
            tempItemVo.setName(orderItem.getProductName());
            orderItemVos.add(tempItemVo);
        }
        AddressId = this.orderMainApi.findAddressIdByOrderNo(orderNo);
        memberAddressDto = this.memberAddressApi.findById(AddressId);
        memberAddressVo = this.copyAddressVo(memberAddressDto);
        orderVo.setCreateTime(orderMainDto.getCreateTime());
        orderVo.setFreight(orderMainDto.getFreight());
        orderVo.setMemberAddress(memberAddressVo);
        orderVo.setOrderItems(orderItemVos);
        orderVo.setOrderNo(orderNo);
        orderVo.setPrice(orderMainDto.getOrderPrice());
        orderVo.setStatus(orderMainDto.getStatus());
        orderVo.setSumPrice(orderMainDto.getSumPrice());
        logger.info("=====================\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u63a5\u53e3\u8fd4\u56de\uff0c\u54cd\u5e94\u53c2\u6570:{})", (Object)JSON.toJSONString((Object)orderVo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return new BaseResponse(true, "\u67e5\u8be2\u6210\u529f", (Object)orderVo);
    }

    public BaseResponse setOrderLogistics(String orderNo, List<SubOrderVo> subOrders, String providerId) {
        Boolean result = false;
        OrderMainDto omd = this.orderMainApi.findByOrderNoAndProviderId(orderNo, providerId);
        if (Lang.isEmpty((Object)omd)) {
            return new BaseResponse(false, "\u672a\u627e\u5230\u4e3b\u8ba2\u5355", (Object)result, "4004");
        }
        if (TrdSpOrderStatus.Received.getCode().equalsIgnoreCase(omd.getTrdSpStatus())) {
            logger.error("\u5df2\u59a5\u6295\u7684\u4e3b\u8ba2\u5355{}\u4e0d\u5141\u8bb8\u4e8c\u6b21\u62c6\u5355", (Object)omd.getOrderNo());
            return new BaseResponse(false, "\u4e3b\u8ba2\u5355\u5df2\u59a5\u6295\uff0c\u4e0d\u80fd\u4e8c\u6b21\u62c6\u5355", (Object)result, "4005");
        }
        this.subOrderApi.deleteSubOrdersByOrderMainId(omd.getId());
        for (SubOrderVo sov : subOrders) {
            SubOrderDto sod = new SubOrderDto();
            sod = this.copyToSubOderDto(sov);
            sod.setTrdOrderState(TrdSpOrderStatus.Sent.getCode());
            this.subOrderApi.saveSubOrder(sod, omd.getId());
        }
        result = true;
        return new BaseResponse(true, "\u8ba2\u5355\u53d1\u8d27\u56de\u5199\u6210\u529f", (Object)result, "0000");
    }

    public BaseResponse setSubOrderAccepted(String subOrderNo, String providerId) {
        try {
            this.subOrderApi.setSubOrderAccepted(subOrderNo, providerId);
        }
        catch (BusinessException e) {
            return new BaseResponse(false, e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new BaseResponse(false, "\u7f51\u7edc\u9519\u8bef", null, "6001");
        }
        return new BaseResponse(true, "\u8ba2\u5355\u59a5\u6295\u56de\u5199\u6210\u529f", (Object)true, "0000");
    }

    public BaseResponse setSubOrderRejected(String subOrderNo, String providerId) {
        try {
            this.subOrderApi.setSubOrderRejected(subOrderNo, providerId);
        }
        catch (BusinessException e) {
            return new BaseResponse(false, e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new BaseResponse(false, "\u7f51\u7edc\u9519\u8bef", null, "6001");
        }
        return new BaseResponse(true, "\u8ba2\u5355\u62d2\u6536\u56de\u5199\u6210\u529f", (Object)true, "0000");
    }

    private MemberAddressVo copyAddressVo(MemberAddressDto mad) {
        MemberAddressVo mav = new MemberAddressVo();
        mav.setReceiverName(mad.getUsername());
        mav.setReceiverPhone(mad.getPhone());
        mav.setReceiverAddressDetails(mad.getAddressDetail());
        mav.setReceiverCounty(mad.getAreaCode());
        mav.setReceiverCountyCode(mad.getAreaCode());
        mav.setReceiverCtiy(mad.getCityName());
        mav.setReceiverCityCode(mad.getCityCode());
        mav.setReceiverProvince(mad.getProvinceName());
        mav.setReceiverProvinceCode(mad.getPostCode());
        mav.setReceivertown(mad.getTownName());
        mav.setReceivertownCode(mad.getTownCode());
        return mav;
    }

    private SubOrderDto copyToSubOderDto(SubOrderVo sov) {
        SubOrderDto sod = new SubOrderDto();
        sod.setLogisticsNo(sov.getLogisticsNo());
        sod.setSubOrderNo(sov.getSubOrderNo());
        List subOderItemVos = sov.getSubOrderItems();
        ArrayList<SubOrderItemDto> subOderItemDtos = new ArrayList<SubOrderItemDto>();
        for (SubOrderItemVo soiv : subOderItemVos) {
            SubOrderItemDto subOrderItemDto = new SubOrderItemDto();
            subOrderItemDto.setCount(soiv.getCount());
            subOrderItemDto.setSkuId(soiv.getSku());
            subOrderItemDto.setName(soiv.getName());
            subOderItemDtos.add(subOrderItemDto);
        }
        sod.setSubOrderItems(subOderItemDtos);
        return sod;
    }
}

