/*
 * Decompiled with CFR 0.152.
 */
package provider.api.gateway.config;

import com.security.exception.Oauth2ExceptionTranslator;
import com.security.oauthfilter.Oauth2AccessDeniedExceptionFilter;
import com.security.oauthfilter.Oauth2ApiRequestTimeValidateFilter;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import provider.api.gateway.filter.ProviderInfoWapperFilter;

@Configuration
@EnableResourceServer
public class ResourceServerConfiguration
extends ResourceServerConfigurerAdapter {
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    ClientDetailsService clientDetailsService;

    public void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity.RequestMatcherConfigurer)((HttpSecurity)http.csrf().disable()).requestMatchers().anyRequest()).and().authorizeRequests().antMatchers(new String[]{"/favicon.ico", "/error"})).permitAll().antMatchers(new String[]{"/**"})).access("#oauth2.hasScope('provider_api')").anyRequest()).access("#oauth2.hasScope('admin')").and()).addFilterAfter((Filter)new Oauth2ApiRequestTimeValidateFilter(), ExceptionTranslationFilter.class).addFilterAfter((Filter)new Oauth2AccessDeniedExceptionFilter(), ExceptionTranslationFilter.class).addFilterBefore((Filter)this.providerInfoWapperFilter(), ExceptionTranslationFilter.class);
    }

    public void configure(ResourceServerSecurityConfigurer resources) throws Exception {
        resources.authenticationEntryPoint((AuthenticationEntryPoint)new Oauth2ExceptionTranslator());
    }

    public ProviderInfoWapperFilter providerInfoWapperFilter() {
        ProviderInfoWapperFilter providerInfoWapperFilter = new ProviderInfoWapperFilter();
        providerInfoWapperFilter.setRedisTemplate(this.redisTemplate);
        providerInfoWapperFilter.setClientDetailsService(this.clientDetailsService);
        return providerInfoWapperFilter;
    }
}

