/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.apiGateway.filters.pre;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.http.HttpServletRequestWrapper;
import java.lang.reflect.Field;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import sinosoftgz.apiGateway.filters.pre.RequestParamWrapperFilter;

public class RequestParamWrapperFilter
extends ZuulFilter {
    private Field requestField = ReflectionUtils.findField(HttpServletRequestWrapper.class, (String)"req", HttpServletRequest.class);
    private Field servletRequestField = ReflectionUtils.findField(ServletRequestWrapper.class, (String)"request", ServletRequest.class);

    public int filterOrder() {
        return 1;
    }

    public RequestParamWrapperFilter() {
        Assert.notNull((Object)this.requestField, (String)"HttpServletRequestWrapper.req field not found");
        Assert.notNull((Object)this.servletRequestField, (String)"ServletRequestWrapper.request field not found");
        this.requestField.setAccessible(true);
        this.servletRequestField.setAccessible(true);
    }

    public String filterType() {
        return "pre";
    }

    public boolean shouldFilter() {
        return true;
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletRequest request = ctx.getRequest();
        FormBodyRequestWrapper wrapper = null;
        if (request instanceof HttpServletRequestWrapper) {
            HttpServletRequest wrapped = (HttpServletRequest)ReflectionUtils.getField((Field)this.requestField, (Object)request);
            wrapper = new FormBodyRequestWrapper(this, wrapped);
            ReflectionUtils.setField((Field)this.requestField, (Object)request, (Object)wrapper);
            if (request instanceof ServletRequestWrapper) {
                ReflectionUtils.setField((Field)this.servletRequestField, (Object)request, (Object)wrapper);
            }
        } else {
            wrapper = new FormBodyRequestWrapper(this, request);
            ctx.setRequest((HttpServletRequest)wrapper);
        }
        if (wrapper != null) {
            ctx.getZuulRequestHeaders().put("content-type", wrapper.getContentType());
        }
        return null;
    }
}

