/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.apiGateway.web;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.netflix.zuul.RoutesRefreshedEvent;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.oauth2.provider.expression.OAuth2ExpressionParser;
import org.springframework.security.oauth2.provider.expression.OAuth2WebSecurityExpressionHandler;
import org.springframework.security.web.access.expression.ExpressionBasedFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import sinosoftgz.apiGateway.config.OAuth2ServerConfig;
import sinosoftgz.apiGateway.event.SecurityMetadataSourceRefreshedEvent;
import sinosoftgz.apiGateway.service.DynamicRegisterRouteAndMetaSourceService;
import sinosoftgz.apiGateway.utils.Reflections;
import sinosoftgz.apiGateway.zuul.DiscoveryDbClientRouteLocator;

@RestController
public class ConfigCtrl {
    OAuth2ExpressionParser spelExpressionParser = new OAuth2ExpressionParser((ExpressionParser)new SpelExpressionParser(new SpelParserConfiguration(false, false)));
    @Autowired
    ApplicationEventPublisher publisher;
    @Autowired
    RouteLocator routeLocator;
    @Autowired
    DynamicRegisterRouteAndMetaSourceService dynamicRegisterRouteAndMetaSourceService;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired
    private LoadBalancerClient loadBalancer;
    @Autowired
    private SpringClientFactory springClientFactory;
    @Autowired
    protected ZuulProperties zuulProperties;
    @Autowired
    DiscoveryDbClientRouteLocator discoveryDbClientRouteLocator;

    @RequestMapping(value={"writeRole"})
    public Object writeOauthRole() {
        FilterSecurityInterceptor filter = (FilterSecurityInterceptor)OAuth2ServerConfig.oauthHttpSecurity.getSharedObject(FilterSecurityInterceptor.class);
        LinkedHashMap requestMap = Maps.newLinkedHashMap();
        OAuth2WebSecurityExpressionHandler expressionHandler = new OAuth2WebSecurityExpressionHandler();
        ExpressionBasedFilterInvocationSecurityMetadataSource metadataSource = (ExpressionBasedFilterInvocationSecurityMetadataSource)filter.getSecurityMetadataSource();
        Map matcherCollectionMap = (Map)Reflections.getFieldValue((Object)metadataSource, (String)"requestMap");
        requestMap.putAll(matcherCollectionMap);
        requestMap.put(new AntPathRequestMatcher("/tt"), SecurityConfig.createList((String[])new String[]{"#oauth2.hasScope('read') and hasRole('ROLE_USER')"}));
        ExpressionBasedFilterInvocationSecurityMetadataSource newMetadataSource = new ExpressionBasedFilterInvocationSecurityMetadataSource(requestMap, (SecurityExpressionHandler)expressionHandler);
        filter.setSecurityMetadataSource((FilterInvocationSecurityMetadataSource)newMetadataSource);
        return "success";
    }

    @RequestMapping(value={"testZuulRoute"})
    public void testZuulRoute() {
        RoutesRefreshedEvent routesRefreshedEvent = new RoutesRefreshedEvent(this.routeLocator);
        this.publisher.publishEvent((ApplicationEvent)routesRefreshedEvent);
    }

    @RequestMapping(value={"testSecurityMetaSource"})
    public void testSecurityMetaSource() {
        this.publisher.publishEvent((ApplicationEvent)new SecurityMetadataSourceRefreshedEvent());
    }

    @RequestMapping(value={"testRefreshRouteAndMetaSource"})
    public void testRefreshRouteAndMetaSource() {
        this.dynamicRegisterRouteAndMetaSourceService.refreshRouteAndMetaSource();
    }

    @RequestMapping(value={"testGetToken"})
    public void testGetToken() {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)"client_2");
        map.add((Object)"client_secret", (Object)"client2_pass");
        map.add((Object)"grant_type", (Object)"client_credentials");
        map.add((Object)"scope", (Object)"read");
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "application/x-www-form-urlencoded");
        HttpEntity req = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity res = this.restTemplate.postForEntity("http://127.0.0.1:8080/oauth/token", (Object)req, String.class, new Object[0]);
        String body = (String)res.getBody();
        System.out.println(body);
    }

    @RequestMapping(value={"testRobbin"})
    public void testRobbin() {
        System.out.println("============");
    }

    @RequestMapping(value={"testZuulProperties"})
    public void testZuulProperties() {
        Map routes = this.zuulProperties.getRoutes();
        List routes1 = this.discoveryDbClientRouteLocator.getRoutes();
        Route matchingRoute1 = this.discoveryDbClientRouteLocator.getMatchingRoute("/pppp/123");
        Route matchingRoute2 = this.discoveryDbClientRouteLocator.getMatchingRoute("/xxxx/321");
        Route matchingRoute3 = this.discoveryDbClientRouteLocator.getMatchingRoute("/ppxx/321");
        Route matchingRoute4 = this.discoveryDbClientRouteLocator.getMatchingRoute("/pppp/fuck");
        System.out.println("=========");
    }
}

