/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.apiGateway.zuul;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.netflix.zuul.filters.RefreshableRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.SimpleRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.netflix.zuul.filters.discovery.ServiceRouteMapper;
import org.springframework.cloud.netflix.zuul.filters.discovery.SimpleServiceRouteMapper;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;
import sinosoftgz.apiGateway.zuul.ZuulRouteVo;

public class DiscoveryDbClientRouteLocator
extends SimpleRouteLocator
implements RefreshableRouteLocator {
    private static final Log log = LogFactory.getLog(DiscoveryDbClientRouteLocator.class);
    public static final String DEFAULT_ROUTE = "/**";
    private DiscoveryClient discovery;
    private ZuulProperties properties;
    private DataSource dataSource;
    private JdbcTemplate jdbcTemplate;
    private ServiceRouteMapper serviceRouteMapper;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public DiscoveryDbClientRouteLocator(String servletPath, DiscoveryClient discovery, ZuulProperties properties) {
        super(servletPath, properties);
        ServiceInstance instance;
        if (properties.isIgnoreLocalService() && (instance = discovery.getLocalServiceInstance()) != null) {
            String localServiceId = instance.getServiceId();
            if (!properties.getIgnoredServices().contains(localServiceId)) {
                properties.getIgnoredServices().add(localServiceId);
            }
        }
        this.serviceRouteMapper = new SimpleServiceRouteMapper();
        this.discovery = discovery;
        this.properties = properties;
    }

    public DiscoveryDbClientRouteLocator(String servletPath, DiscoveryClient discovery, ZuulProperties properties, ServiceRouteMapper serviceRouteMapper) {
        this(servletPath, discovery, properties);
        this.serviceRouteMapper = serviceRouteMapper;
    }

    public void addRoute(String path, String location) {
        this.properties.getRoutes().put(path, new ZuulProperties.ZuulRoute(path, location));
        this.refresh();
    }

    public void addRoute(ZuulProperties.ZuulRoute route) {
        this.properties.getRoutes().put(route.getPath(), route);
        this.refresh();
    }

    private Map<String, ZuulProperties.ZuulRoute> refreshRouteFromDb() {
        LinkedHashMap<String, ZuulProperties.ZuulRoute> routes = new LinkedHashMap<String, ZuulProperties.ZuulRoute>();
        List results = this.jdbcTemplate.query("SELECT * FROM gateway_api_define WHERE enabled = TRUE ", (RowMapper)new BeanPropertyRowMapper(ZuulRouteVo.class));
        for (ZuulRouteVo result : results) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)result.getPath()) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)result.getServiceId()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)result.getUrl())) continue;
            ZuulProperties.ZuulRoute zuulRoute = new ZuulProperties.ZuulRoute();
            try {
                BeanUtils.copyProperties((Object)zuulRoute, (Object)result);
            }
            catch (Exception e) {
                log.error((Object)"=============load zuul route info from db with error==============", (Throwable)e);
            }
            routes.put(zuulRoute.getPath(), zuulRoute);
        }
        return routes;
    }

    protected LinkedHashMap<String, ZuulProperties.ZuulRoute> locateRoutes() {
        LinkedHashMap<String, ZuulProperties.ZuulRoute> routesMap = new LinkedHashMap<String, ZuulProperties.ZuulRoute>();
        routesMap.putAll(super.locateRoutes());
        routesMap.putAll(this.refreshRouteFromDb());
        if (this.discovery != null) {
            LinkedHashMap<String, ZuulProperties.ZuulRoute> staticServices = new LinkedHashMap<String, ZuulProperties.ZuulRoute>();
            for (ZuulProperties.ZuulRoute zuulRoute : routesMap.values()) {
                Object serviceId = zuulRoute.getServiceId();
                if (serviceId == null) {
                    serviceId = zuulRoute.getId();
                }
                if (serviceId == null) continue;
                staticServices.put((String)serviceId, zuulRoute);
            }
            List services = this.discovery.getServices();
            String[] stringArray = this.properties.getIgnoredServices().toArray(new String[0]);
            for (String serviceId : services) {
                ZuulProperties.ZuulRoute staticRoute;
                String key = "/" + this.mapRouteToService(serviceId) + DEFAULT_ROUTE;
                if (staticServices.containsKey(serviceId) && ((ZuulProperties.ZuulRoute)staticServices.get(serviceId)).getUrl() == null && !StringUtils.hasText((String)(staticRoute = (ZuulProperties.ZuulRoute)staticServices.get(serviceId)).getLocation())) {
                    staticRoute.setLocation(serviceId);
                }
                if (PatternMatchUtils.simpleMatch((String[])stringArray, (String)serviceId) || routesMap.containsKey(key)) continue;
                routesMap.put(key, new ZuulProperties.ZuulRoute(key, serviceId));
            }
        }
        if (routesMap.get(DEFAULT_ROUTE) != null) {
            ZuulProperties.ZuulRoute defaultRoute = (ZuulProperties.ZuulRoute)routesMap.get(DEFAULT_ROUTE);
            routesMap.remove(DEFAULT_ROUTE);
            routesMap.put(DEFAULT_ROUTE, defaultRoute);
        }
        LinkedHashMap<String, ZuulProperties.ZuulRoute> values = new LinkedHashMap<String, ZuulProperties.ZuulRoute>();
        for (Map.Entry entry : routesMap.entrySet()) {
            String path = (String)entry.getKey();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (StringUtils.hasText((String)this.properties.getPrefix()) && !(path = this.properties.getPrefix() + path).startsWith("/")) {
                path = "/" + path;
            }
            values.put(path, (ZuulProperties.ZuulRoute)entry.getValue());
        }
        return values;
    }

    public void refresh() {
        this.doRefresh();
    }

    protected String mapRouteToService(String serviceId) {
        return this.serviceRouteMapper.apply(serviceId);
    }

    protected void addConfiguredRoutes(Map<String, ZuulProperties.ZuulRoute> routes) {
        Map routeEntries = this.properties.getRoutes();
        for (ZuulProperties.ZuulRoute entry : routeEntries.values()) {
            String route = entry.getPath();
            if (routes.containsKey(route)) {
                log.warn((Object)("Overwriting route " + route + ": already defined by " + routes.get(route)));
            }
            routes.put(route, entry);
        }
    }
}

