/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.apiGateway.zuul;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;
import sinosoftgz.gateway.model.GatewayClientConfigRelation;
import sinosoftgz.gateway.model.GatewayRateLimit;
import sinosoftgz.utils.Lang;

@Component
public class RateLimitContext {
    public Map<String, GatewayRateLimit> rateLimitMap;
    public Map<String, GatewayRateLimit> timesLimitMap;
    @Autowired
    JdbcTemplate jdbcTemplate;

    @PostConstruct
    public void init() {
        System.out.println("\u5f00\u59cb\u521d\u59cb\u5316RateLimitContext=======");
        this.refresh();
    }

    public void refresh() {
        System.out.println("\u5f00\u59cb\u5237\u65b0RateLimitContext=======");
        ConcurrentHashMap rateLimitMap = new ConcurrentHashMap();
        ConcurrentHashMap timesLimitMap = new ConcurrentHashMap();
        List gatewayClientConfigRelations = this.jdbcTemplate.query("select * from gateway_client_config_relation", (RowMapper)new BeanPropertyRowMapper(GatewayClientConfigRelation.class));
        List gatewayRateLimitList = this.jdbcTemplate.query("select * from gateway_rate_limit", (RowMapper)new BeanPropertyRowMapper(GatewayRateLimit.class));
        HashMap<String, GatewayRateLimit> gatewayRateLimitMap = new HashMap<String, GatewayRateLimit>();
        for (GatewayRateLimit gatewayOauthClientDetails : gatewayRateLimitList) {
            gatewayRateLimitMap.put(gatewayOauthClientDetails.getId(), gatewayOauthClientDetails);
        }
        for (GatewayClientConfigRelation gatewayClientConfigRelation : gatewayClientConfigRelations) {
            if (!Lang.isEmpty((Object)gatewayClientConfigRelation.getRateLimitId())) {
                rateLimitMap.put(gatewayClientConfigRelation.getClientId() + ":" + gatewayClientConfigRelation.getApiDefineId(), gatewayRateLimitMap.get(gatewayClientConfigRelation.getRateLimitId()));
            }
            if (Lang.isEmpty((Object)gatewayClientConfigRelation.getTimeLimitId())) continue;
            timesLimitMap.put(gatewayClientConfigRelation.getClientId() + ":" + gatewayClientConfigRelation.getApiDefineId(), gatewayRateLimitMap.get(gatewayClientConfigRelation.getTimeLimitId()));
        }
        this.rateLimitMap = rateLimitMap;
        this.timesLimitMap = timesLimitMap;
    }

    public void singleSaveOrUpdate(String configId) {
        GatewayClientConfigRelation gatewayClientConfigRelation = (GatewayClientConfigRelation)this.jdbcTemplate.queryForObject("select * from gateway_client_config_relation where id =?", new Object[]{configId}, (RowMapper)new BeanPropertyRowMapper(GatewayClientConfigRelation.class));
        String key = gatewayClientConfigRelation.getClientId() + ":" + gatewayClientConfigRelation.getApiDefineId();
        String rateLimitId = gatewayClientConfigRelation.getRateLimitId();
        if (Lang.isEmpty((Object)rateLimitId)) {
            this.rateLimitMap.remove(key);
        } else {
            GatewayRateLimit rateLimit = (GatewayRateLimit)this.jdbcTemplate.queryForObject("select * from gateway_rate_limit where id =?", new Object[]{rateLimitId}, (RowMapper)new BeanPropertyRowMapper(GatewayRateLimit.class));
            this.rateLimitMap.put(key, rateLimit);
        }
        String timeLimitId = gatewayClientConfigRelation.getTimeLimitId();
        if (Lang.isEmpty((Object)timeLimitId)) {
            this.timesLimitMap.remove(key);
        } else {
            GatewayRateLimit timeLimit = (GatewayRateLimit)this.jdbcTemplate.queryForObject("select * from gateway_rate_limit where id =?", new Object[]{timeLimitId}, (RowMapper)new BeanPropertyRowMapper(GatewayRateLimit.class));
            this.timesLimitMap.put(key, timeLimit);
        }
    }

    public void singleDelete(String key) {
        if (this.timesLimitMap.containsKey(key)) {
            this.timesLimitMap.remove(key);
        }
        if (this.rateLimitMap.containsKey(key)) {
            this.rateLimitMap.remove(key);
        }
    }
}

