/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.config;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.JdbcUserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.provisioning.JdbcUserDetailsManager;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import sinosoftgz.config.CustomPasswordEncoderConfig;
import sinosoftgz.utils.springsecurity.SecuritySqlProperties;

@Configuration
@EnableWebSecurity
public class AdminSecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired(required=false)
    private DataSource dataSource;
    @Autowired(required=false)
    private SecuritySqlProperties securitySqlProperties;
    @Autowired
    private ManagementServerProperties managementServerProperties;
    RequestMatcher csrfRequestMatcher = new RequestMatcher(){
        private AntPathRequestMatcher[] requestMatchers = new AntPathRequestMatcher[]{new AntPathRequestMatcher("/mail-sms-admin/smsTemplate/saveOrUpdate"), new AntPathRequestMatcher("/mail-sms-admin/smsMessage/saveOrUpdate"), new AntPathRequestMatcher("/mail-sms-admin/smsTemplateConfig/saveOrUpdate"), new AntPathRequestMatcher("/mail-sms-admin/smsTemplateValidate/saveOrUpdate"), new AntPathRequestMatcher("/mail-sms-admin/smsValidate/saveOrUpdate"), new AntPathRequestMatcher("/mail-sms-admin/mailTemplateValidate/validate"), new AntPathRequestMatcher("/mail-sms-admin/mailValidate/validate"), new AntPathRequestMatcher("/mail-sms-admin/smsTemplateValidate/validate"), new AntPathRequestMatcher("/mail-sms-admin/smsValidate/validate"), new AntPathRequestMatcher("/channel-admin/channel/saveChannel"), new AntPathRequestMatcher("/channel-admin/agreement/saveAgreement"), new AntPathRequestMatcher("/channel-admin/channelsell/saveChannelSellInfo"), new AntPathRequestMatcher("/channel-admin/channelsell/editChannelSellInfo"), new AntPathRequestMatcher("/channel-admin/channelCompany/saveCompany"), new AntPathRequestMatcher("/admin/user/saveUser"), new AntPathRequestMatcher("/admin/company/saveAdminCompany"), new AntPathRequestMatcher("/admin/role/addOrUpdate"), new AntPathRequestMatcher("/policy-product-admin/insuranceBasic/prpdClass/updateSave"), new AntPathRequestMatcher("/policy-product-admin/insuranceBasic/prpdCompany/updateSave"), new AntPathRequestMatcher("/policy-product-admin/insuranceBasic/prpdRisk/updateSave"), new AntPathRequestMatcher("/policy-product-admin/insuranceBasic/prpdRiskClause/updateSave"), new AntPathRequestMatcher("/policy-product-admin/insuranceBasic/prpdRiskClauseKind/updateSave"), new AntPathRequestMatcher("/policy-product-admin/insuranceBasic/prpdRiskEngage/editRiskEngage"), new AntPathRequestMatcher("/policy-product-admin/insuranceBasic/prpdRiskItem/editRiskItem"), new AntPathRequestMatcher("/policy-product-admin/insuranceBasic/prpdPlanLimit/editRiskLimit"), new AntPathRequestMatcher("/ediadmin/company/doAdd"), new AntPathRequestMatcher("/ediadmin/company/doUpdate"), new AntPathRequestMatcher("/ediadmin/ediAction/doAdd"), new AntPathRequestMatcher("/ediadmin/ediAction/doUpdate"), new AntPathRequestMatcher("/ediadmin/ediAction/doPublish")};

        public boolean matches(HttpServletRequest request) {
            for (AntPathRequestMatcher rm : this.requestMatchers) {
                if (!rm.matches(request)) continue;
                return true;
            }
            return false;
        }
    };

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        if (this.dataSource == null || this.securitySqlProperties == null) {
            return;
        }
        JdbcUserDetailsManagerConfigurer jdbcUserDetailsManagerConfigurer = (JdbcUserDetailsManagerConfigurer)auth.jdbcAuthentication().dataSource(this.dataSource).passwordEncoder((PasswordEncoder)new CustomPasswordEncoderConfig());
        JdbcUserDetailsManager jdbcUserDetailsManager = jdbcUserDetailsManagerConfigurer.getUserDetailsService();
        jdbcUserDetailsManager.setDataSource(this.dataSource);
        jdbcUserDetailsManager.setGroupAuthoritiesByUsernameQuery(this.securitySqlProperties.getGroupAuthoritiesByUsernameQuery());
        jdbcUserDetailsManager.setAuthoritiesByUsernameQuery(this.securitySqlProperties.getAuthoritiesByUsernameQuery());
        jdbcUserDetailsManager.setUsersByUsernameQuery(this.securitySqlProperties.getUsersByUsernameQuery());
        jdbcUserDetailsManager.setEnableGroups(false);
    }

    public void configure(WebSecurity web) throws Exception {
        super.configure(web);
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.headers().frameOptions().sameOrigin();
        ((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity.RequestMatcherConfigurer)http.requestMatchers().anyRequest()).and().authorizeRequests().antMatchers(new String[]{"/lte/**"})).permitAll().antMatchers(new String[]{"/dwz/**"})).permitAll().antMatchers(new String[]{"/static/**"})).permitAll().antMatchers(new String[]{"/css/**"})).permitAll().antMatchers(new String[]{"/js/**"})).permitAll().antMatchers(new String[]{"/image/**"})).permitAll().antMatchers(new String[]{"/images/**"})).permitAll().antMatchers(new String[]{"/admin/login/**"})).permitAll().antMatchers(new String[]{"/admin/logout/**"})).permitAll().antMatchers(new String[]{this.managementServerProperties.getContextPath() + "/**"})).permitAll().anyRequest()).authenticated().and()).logout().logoutRequestMatcher((RequestMatcher)new AntPathRequestMatcher("/admin/logout")).and()).csrf().requireCsrfProtectionMatcher((RequestMatcher)new AntPathRequestMatcher("/admin/login", HttpMethod.POST.toString())).and()).csrf().requireCsrfProtectionMatcher(this.csrfRequestMatcher).and()).formLogin().loginPage("/admin/login").defaultSuccessUrl("/admin")).successHandler((AuthenticationSuccessHandler)new SavedRequestAwareAuthenticationSuccessHandler(){

            public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws ServletException, IOException {
                super.onAuthenticationSuccess(request, response, authentication);
            }
        })).and()).httpBasic();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(prefix="admin.security")
    SecuritySqlProperties securitySqlProperties() {
        return new SecuritySqlProperties();
    }
}

