/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.beetl.core.ErrorHandler;
import org.beetl.core.Format;
import org.beetl.core.Function;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.TagFactory;
import org.beetl.core.VirtualAttributeEval;
import org.beetl.core.VirtualClassAttribute;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.ext.spring.BeetlGroupUtilConfiguration;
import org.beetl.ext.spring.BeetlSpringViewResolver;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.WebMvcProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.resource.ResourceUrlProvider;
import sinosoftgz.utils.beetl.BeetlProperties;
import sinosoftgz.utils.freemarker.EncodeURLMethod;

@Configuration
public class BeetlConfig
implements InitializingBean,
ServletContextAware {
    @Value(value="${context.commonstatic}")
    private String commonStaticPath;
    @Value(value="${context.projectstatic}")
    private String projectStaticPath;
    @Value(value="${context.ctx}")
    private String dynaContentPath;
    @Autowired
    ResourceUrlProvider resourceUrlProvider;
    @Autowired
    private BeetlProperties properties;
    @Autowired
    private WebMvcProperties webMvcProperties;
    @Autowired(required=false)
    @Qualifier(value="beetlFunctions")
    private Map<String, Function> functions = null;
    @Autowired(required=false)
    @Qualifier(value="beetlTypeFormats")
    private Map<Class<?>, Format> typeFormats = null;
    @Autowired(required=false)
    @Qualifier(value="beetlFormats")
    private Map<String, Format> formats = null;
    @Autowired(required=false)
    @Qualifier(value="beetlTagFactorys")
    private Map<String, TagFactory> tagFactorys = null;
    @Autowired(required=false)
    @Qualifier(value="beetlFunctionPackages")
    private Map<String, Object> functionPackages = null;
    @Autowired(required=false)
    @Qualifier(value="beetlVirtualClassAttributes")
    private Map<Class<?>, VirtualClassAttribute> virtualClassAttributes = null;
    @Autowired(required=false)
    @Qualifier(value="beetlVirtualAttributeEvals")
    private List<VirtualAttributeEval> virtualAttributeEvals = null;
    @Autowired(required=false)
    @Qualifier(value="beetlErrorHandler")
    protected ErrorHandler errorHandler = null;
    @Autowired(required=false)
    @Qualifier(value="beetlSharedVars")
    protected Map<String, Object> sharedVars = null;
    BeetlGroupUtilConfiguration beetlGroupUtilConfiguration;
    ServletContext servletContext;

    @Bean
    public EncodeURLMethod encodeURLMethod() {
        return new EncodeURLMethod(this.resourceUrlProvider);
    }

    @Bean(initMethod="init", name={"beetlConfig"})
    public BeetlGroupUtilConfiguration getBeetlGroupUtilConfiguration() {
        BeetlGroupUtilConfiguration beetlGroupUtilConfiguration = new BeetlGroupUtilConfiguration();
        try {
            ClasspathResourceLoader cploder = new ClasspathResourceLoader(BeetlConfig.class.getClassLoader(), this.properties.getTemplatesPath());
            if (this.properties.getConfig() != null) {
                beetlGroupUtilConfiguration.setConfigProperties(this.properties.getConfig().toProperties());
            }
            if (this.functions != null) {
                beetlGroupUtilConfiguration.setFunctions(this.functions);
            }
            if (this.typeFormats != null) {
                beetlGroupUtilConfiguration.setTypeFormats(this.typeFormats);
            }
            if (this.formats != null) {
                beetlGroupUtilConfiguration.setFormats(this.formats);
            }
            if (this.tagFactorys != null) {
                beetlGroupUtilConfiguration.setTagFactorys(this.tagFactorys);
            }
            if (this.functionPackages != null && this.functionPackages.get("beetlFunctionPackages") != null) {
                beetlGroupUtilConfiguration.setFunctionPackages((Map)this.functionPackages.get("beetlFunctionPackages"));
            }
            if (this.virtualClassAttributes != null) {
                beetlGroupUtilConfiguration.setVirtualClassAttributes(this.virtualClassAttributes);
            }
            if (this.virtualAttributeEvals != null) {
                beetlGroupUtilConfiguration.setVirtualAttributeEvals(this.virtualAttributeEvals);
            }
            if (this.errorHandler != null) {
                beetlGroupUtilConfiguration.setErrorHandler(this.errorHandler);
            }
            if (this.sharedVars != null && this.sharedVars.get("beetlSharedVars") != null) {
                beetlGroupUtilConfiguration.setSharedVars((Map)this.sharedVars.get("beetlSharedVars"));
            }
            beetlGroupUtilConfiguration.setResourceLoader((ResourceLoader)cploder);
            this.beetlGroupUtilConfiguration = beetlGroupUtilConfiguration;
            return beetlGroupUtilConfiguration;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Bean(name={"beetlViewResolver"})
    public BeetlSpringViewResolver getBeetlSpringViewResolver(@Qualifier(value="beetlConfig") BeetlGroupUtilConfiguration beetlGroupUtilConfiguration) {
        BeetlSpringViewResolver beetlSpringViewResolver = new BeetlSpringViewResolver();
        beetlSpringViewResolver.setContentType("text/html;charset=UTF-8");
        beetlSpringViewResolver.setOrder(0);
        beetlSpringViewResolver.setConfig(beetlGroupUtilConfiguration);
        if (this.webMvcProperties != null && this.webMvcProperties.getView() != null) {
            WebMvcProperties.View view = this.webMvcProperties.getView();
            if (!StringUtils.isEmpty((Object)view.getPrefix())) {
                beetlSpringViewResolver.setPrefix(view.getPrefix());
            }
            if (!StringUtils.isEmpty((Object)view.getSuffix())) {
                beetlSpringViewResolver.setSuffix(view.getSuffix());
            }
        }
        return beetlSpringViewResolver;
    }

    public void afterPropertiesSet() throws Exception {
        GroupTemplate groupTemplate = this.beetlGroupUtilConfiguration.getGroupTemplate();
        if (groupTemplate.getSharedVars() == null) {
            groupTemplate.setSharedVars(new HashMap());
        }
        String projectContextPath = this.servletContext.getContextPath();
        groupTemplate.getSharedVars().put("c_static", this.commonStaticPath);
        if (StringUtils.isEmpty((Object)this.commonStaticPath)) {
            groupTemplate.getSharedVars().put("c_static", projectContextPath);
        }
        groupTemplate.getSharedVars().put("p_static", this.projectStaticPath);
        if (StringUtils.isEmpty((Object)this.projectStaticPath)) {
            groupTemplate.getSharedVars().put("p_static", projectContextPath);
        }
        groupTemplate.getSharedVars().put("ctx", this.dynaContentPath);
        if (StringUtils.isEmpty((Object)this.dynaContentPath)) {
            groupTemplate.getSharedVars().put("ctx", projectContextPath);
        }
        groupTemplate.getSharedVars().put("_v", this.encodeURLMethod());
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

