/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.config;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import sinosoftgz.utils.filter.FrontEndLoginCheckFilter;
import sinosoftgz.utils.filter.InjectionAttackFilter;

@Configuration
public class FrontEndSecurityConfig {
    @Value(value="${security.frontend.login.exclude-urls}")
    private String excludeUrls;
    @Value(value="${security.frontend.login.login-url}")
    private String loginUrl;
    @Value(value="${security.frontend.login.check-urls}")
    private String checkUrls;
    @Value(value="${security.frontend.login.default-success-url}")
    private String defaultSuccessUrl;
    @Value(value="${security.frontend.login.protect-urls}")
    private List<String> protectUrls;

    @Bean
    public FrontEndLoginCheckFilter frontEndLoginCheckFilter() {
        FrontEndLoginCheckFilter frontEndLoginCheckFilter = new FrontEndLoginCheckFilter();
        frontEndLoginCheckFilter.setExcludeUrls(this.excludeUrls);
        frontEndLoginCheckFilter.setLoginUrl(this.loginUrl);
        frontEndLoginCheckFilter.setCheckUrls(this.checkUrls);
        frontEndLoginCheckFilter.setDefaultSuccessUrl(this.defaultSuccessUrl);
        return frontEndLoginCheckFilter;
    }

    @Bean
    FilterRegistrationBean filterRegistrationBean() {
        InjectionAttackFilter filter = new InjectionAttackFilter();
        filter.setFilterXSS(true);
        filter.setFilterSQL(true);
        filter.setClickJacking(true);
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        if (this.protectUrls == null || this.protectUrls.size() == 0) {
            ArrayList<String> urls = new ArrayList<String>();
            urls.add("/**");
            registrationBean.setUrlPatterns(urls);
        } else {
            registrationBean.setUrlPatterns(this.protectUrls);
        }
        registrationBean.setOrder(Integer.MIN_VALUE);
        return registrationBean;
    }
}

