/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;

@Configuration
@EnableRedisHttpSession
public class SessionConfig {
    @Autowired
    ServerProperties serverProperties;

    @Bean
    public CookieSerializer cookieSerializer() {
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        serializer.setCookieName(this.serverProperties.getSession().getCookie().getName());
        serializer.setCookiePath(this.serverProperties.getSession().getCookie().getPath());
        serializer.setDomainName(this.serverProperties.getSession().getCookie().getDomain());
        if (this.serverProperties.getSession().getCookie().getSecure() != null) {
            serializer.setUseSecureCookie(this.serverProperties.getSession().getCookie().getSecure().booleanValue());
        }
        serializer.setDomainNamePattern("^.+?\\.(\\w+\\.[a-z]+)$");
        return serializer;
    }
}

