/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.data;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import sinosoftgz.utils.Lang;
import sinosoftgz.utils.convert.Converters;
import sinosoftgz.utils.lang.Copys;
import sinosoftgz.utils.lang.Maps;
import sinosoftgz.utils.lang.Mirrors;

public class Beans {
    public static Copys from(Object from) {
        return Copys.create().from(from);
    }

    public static Copys to(Object ... tos) {
        return Copys.create().to(tos);
    }

    public static void set(Object bean, Converters converters, String nameString, Object ... args) {
        Lang.notNull(bean, "The bean should not be null", new Object[0]);
        Lang.notNull(converters, "The converters should not be null", new Object[0]);
        Lang.notNull(args, "The args should not be null", new Object[0]);
        Lang.isTrue(!Lang.isEmpty(nameString), "The nameString should not be empty", new Object[0]);
        String[] names = nameString.split("[\\s,\uff0c]+");
        Lang.isTrue(names.length == args.length, "The names length is %d but got %d arguments", names.length, args.length);
        Class<?> beanType = bean.getClass();
        Map<String, PropertyDescriptor> propertyMap = Maps.caseInsensitiveMap(Mirrors.getPropertyMap(beanType));
        for (int i = 0; i < names.length; ++i) {
            String name = names[i].trim();
            PropertyDescriptor propertyDescriptor = propertyMap.get(name);
            Lang.notNull(propertyDescriptor, "The property %s is not exist in bean %s", name, bean);
            Method writeMethod = propertyDescriptor.getWriteMethod();
            Lang.notNull(writeMethod, "The property %s in bean %s is read only", name, bean);
            Object value = converters.convert(args[i], propertyDescriptor.getPropertyType());
            try {
                writeMethod.invoke(bean, value);
                continue;
            }
            catch (IllegalAccessException e) {
                throw Lang.unchecked(e);
            }
            catch (IllegalArgumentException e) {
                throw Lang.unchecked(e);
            }
            catch (InvocationTargetException e) {
                throw Lang.unchecked(e);
            }
        }
    }

    public static void set(Object bean, String nameString, Object ... args) {
        Beans.set(bean, Converters.BASE, nameString, args);
    }
}

