/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.data;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class DateUtils {
    public static String getNowTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(Calendar.getInstance().getTime());
    }

    public static Date getNextDay(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, 1);
        Date nextDay = calendar.getTime();
        return nextDay;
    }

    public static String getNowTimeZ() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
        return sdf.format(Calendar.getInstance().getTime());
    }

    public static String getNowDateString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(Calendar.getInstance().getTime());
    }

    public static String TimeToTime(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = sdf.parse(time);
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
            return sdf1.format(date.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return time;
        }
    }

    public static String getTimeBeforeORAfter(int days) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar c = Calendar.getInstance();
        c.add(5, days);
        return sdf.format(c.getTime());
    }

    public static Date toDate(String date, String pattern) {
        if (("" + date).equals("")) {
            return null;
        }
        if (pattern == null) {
            pattern = "yyyy-MM-dd";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Date newDate = new Date();
        try {
            newDate = sdf.parse(date);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return newDate;
    }

    public static String toString(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        if (pattern == null) {
            pattern = "yyyy-MM-dd";
        }
        String dateString = "";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            dateString = sdf.format(date);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dateString;
    }

    public static Date getNowDate() {
        Date currentTime = new Date();
        return currentTime;
    }

    public static Date getNowDateShort() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(currentTime);
        Date currentTime_2 = null;
        try {
            currentTime_2 = formatter.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return currentTime_2;
    }

    public static String getStringDate() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static String getStringDateShort() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static String getTimeShort() {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        Date currentTime = new Date();
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static Date strToDateLong(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    public static String dateToStrLong(Date dateDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(dateDate);
        return dateString;
    }

    public static String dateToStr(Date dateDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(dateDate);
        return dateString;
    }

    public static String dateToStr(Date dateDate, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(dateDate);
    }

    public static Date strToDate(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    public static Date longStrToDate(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    public static Date strToDate(String strDate, String patten) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        if (patten != null || patten.length() > 0) {
            formatter = new SimpleDateFormat(patten);
        }
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    public static Date getNow() {
        Date currentTime = new Date();
        return currentTime;
    }

    public static Date getNowBefore(int minute) {
        Date currentTime = new Date();
        long Times = currentTime.getTime() - (long)(minute * 60 * 1000);
        currentTime.setTime(Times);
        return currentTime;
    }

    public static String getCurrentDateStr() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static Date getLastDate(long day) {
        Date date = new Date();
        long date_3_hm = date.getTime() - 122400000L * day;
        Date date_3_hm_date = new Date(date_3_hm);
        return date_3_hm_date;
    }

    public static String getStringToday() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd HHmmss");
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static String getStringTodayto() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static String getHour() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(currentTime);
        String hour = dateString.substring(11, 13);
        return hour;
    }

    public static String getTime() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(currentTime);
        String min = dateString.substring(14, 16);
        return min;
    }

    public static String getUserDate(String sformat) {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat(sformat);
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static String getTwoHour(String st1, String st2) {
        double u;
        String[] kk = null;
        String[] jj = null;
        kk = st1.split(":");
        jj = st2.split(":");
        if (Integer.parseInt(kk[0]) < Integer.parseInt(jj[0])) {
            return "0";
        }
        double y = Double.parseDouble(kk[0]) + Double.parseDouble(kk[1]) / 60.0;
        if (y - (u = Double.parseDouble(jj[0]) + Double.parseDouble(jj[1]) / 60.0) > 0.0) {
            return y - u + "";
        }
        return "0";
    }

    public static String getTwoDay(String sj1, String sj2) {
        SimpleDateFormat myFormatter = new SimpleDateFormat("yyyy-MM-dd");
        long day = 0L;
        try {
            Date date = myFormatter.parse(sj1);
            Date mydate = myFormatter.parse(sj2);
            day = (date.getTime() - mydate.getTime()) / 86400000L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return day + "";
    }

    public static String getPreTime(String sj1, String jj) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String mydate1 = "";
        try {
            Date date1 = format.parse(sj1);
            long Time = date1.getTime() / 1000L + (long)(Integer.parseInt(jj) * 60);
            date1.setTime(Time * 1000L);
            mydate1 = format.format(date1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mydate1;
    }

    public static String getNextDay(String nowdate, String delay) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String mdate = "";
            Date d = DateUtils.strToDate(nowdate);
            long myTime = d.getTime() / 1000L + Long.parseLong(delay) * 24L * 60L * 60L;
            d.setTime(myTime * 1000L);
            mdate = format.format(d);
            return mdate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getNextDaytoSen(String statrdate, String delay) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String mdate = "";
            Date d = DateUtils.strToDate(statrdate, "yyyy-MM-dd HH:mm:ss");
            long myTime = d.getTime() / 1000L + Long.parseLong(delay) * 24L * 60L * 60L;
            d.setTime(myTime * 1000L);
            mdate = format.format(d);
            return mdate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean isLeapYear(String ddate) {
        Date d = DateUtils.strToDate(ddate);
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(d);
        int year = gc.get(1);
        if (year % 400 == 0) {
            return true;
        }
        if (year % 4 == 0) {
            return year % 100 != 0;
        }
        return false;
    }

    public static String getEDate(String str) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(str, pos);
        String j = strtodate.toString();
        String[] k = j.split(" ");
        return k[2] + k[1].toUpperCase() + k[5].substring(2, 4);
    }

    public static String getEndDateOfMonth(String dat) {
        String str = dat.substring(0, 8);
        String month = dat.substring(5, 7);
        int mon = Integer.parseInt(month);
        str = mon == 1 || mon == 3 || mon == 5 || mon == 7 || mon == 8 || mon == 10 || mon == 12 ? str + "31" : (mon == 4 || mon == 6 || mon == 9 || mon == 11 ? str + "30" : (DateUtils.isLeapYear(dat) ? str + "29" : str + "28"));
        return str;
    }

    public static boolean isSameWeekDates(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        int subYear = cal1.get(1) - cal2.get(1);
        return 0 == subYear ? cal1.get(3) == cal2.get(3) : (1 == subYear && 11 == cal2.get(2) ? cal1.get(3) == cal2.get(3) : -1 == subYear && 11 == cal1.get(2) && cal1.get(3) == cal2.get(3));
    }

    public static String getSeqWeek() {
        Calendar c = Calendar.getInstance(Locale.CHINA);
        String week = Integer.toString(c.get(3));
        if (week.length() == 1) {
            week = "0" + week;
        }
        String year = Integer.toString(c.get(1));
        return year + week;
    }

    public static String getWeek(String sdate, String num) {
        Date dd = DateUtils.strToDate(sdate);
        Calendar c = Calendar.getInstance();
        c.setTime(dd);
        if (num.equals("1")) {
            c.set(7, 2);
        } else if (num.equals("2")) {
            c.set(7, 3);
        } else if (num.equals("3")) {
            c.set(7, 4);
        } else if (num.equals("4")) {
            c.set(7, 5);
        } else if (num.equals("5")) {
            c.set(7, 6);
        } else if (num.equals("6")) {
            c.set(7, 7);
        } else if (num.equals("0")) {
            c.set(7, 1);
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
    }

    public static String getWeek(String sdate) {
        Date date = DateUtils.strToDate(sdate);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return new SimpleDateFormat("EEEE").format(c.getTime());
    }

    public static String getWeekStr(String sdate) {
        String str = "";
        str = DateUtils.getWeek(sdate);
        if ("1".equals(str)) {
            str = "\u661f\u671f\u65e5";
        } else if ("2".equals(str)) {
            str = "\u661f\u671f\u4e00";
        } else if ("3".equals(str)) {
            str = "\u661f\u671f\u4e8c";
        } else if ("4".equals(str)) {
            str = "\u661f\u671f\u4e09";
        } else if ("5".equals(str)) {
            str = "\u661f\u671f\u56db";
        } else if ("6".equals(str)) {
            str = "\u661f\u671f\u4e94";
        } else if ("7".equals(str)) {
            str = "\u661f\u671f\u516d";
        }
        return str;
    }

    public static long getDays(String date1, String date2) {
        if (date1 == null || date1.equals("")) {
            return 0L;
        }
        if (date2 == null || date2.equals("")) {
            return 0L;
        }
        SimpleDateFormat myFormatter = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        Date mydate = null;
        try {
            date = myFormatter.parse(date1);
            mydate = myFormatter.parse(date2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long day = (date.getTime() - mydate.getTime()) / 86400000L;
        return day;
    }

    public static String getNowMonth(String sdate) {
        sdate = sdate.substring(0, 8) + "01";
        Date date = DateUtils.strToDate(sdate);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int u = c.get(7);
        String newday = DateUtils.getNextDay(sdate, 1 - u + "");
        return newday;
    }

    public static long getDistinceMonth(String beforedate, String afterdate) throws ParseException {
        SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd");
        long monthCount = 0L;
        try {
            Date d1 = d.parse(beforedate);
            Date d2 = d.parse(afterdate);
            monthCount = (d2.getYear() - d1.getYear()) * 12 + d2.getMonth() - d1.getMonth();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return monthCount;
    }

    public static long getDistinceDay(String beforedate, String afterdate) throws ParseException {
        SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd");
        long dayCount = 0L;
        try {
            Date d1 = d.parse(beforedate);
            Date d2 = d.parse(afterdate);
            dayCount = (d2.getTime() - d1.getTime()) / 86400000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dayCount;
    }

    public static String disTime(Date date1, Date date2) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return DateUtils.disTime(df.format(date1), df.format(date2));
    }

    public static int disDay(String date1, String date2) {
        int day = 0;
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            Date now = df.parse(date1);
            Date date = df.parse(date2);
            long l = now.getTime() - date.getTime();
            day = (int)(l / 86400000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }

    public static double disDateTime(String date1, String date2) {
        double la = 0.0;
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date now = df.parse(date1);
            Date date = df.parse(date2);
            long l = now.getTime() - date.getTime();
            long day = l / 86400000L;
            long hour = l / 3600000L - day * 24L;
            double min = l / 60000L - day * 24L * 60L - hour * 60L;
            double s = (double)(l / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L) - min * 60.0;
            la = (double)(day * 24L + hour) + min / 60.0 + s / 3600.0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return la;
    }

    public static String disTime(String date1, String date2) {
        StringBuffer sb = new StringBuffer();
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date now = df.parse(date1);
            Date date = df.parse(date2);
            long l = now.getTime() - date.getTime();
            long day = l / 86400000L;
            long hour = l / 3600000L - day * 24L;
            long min = l / 60000L - day * 24L * 60L - hour * 60L;
            if (day <= 0L && hour <= 0L && min <= 0L) {
                return "1";
            }
            if (day > 0L) {
                sb.append(day + "\u5929");
            }
            if (hour > 0L) {
                sb.append(hour + "\u5c0f\u65f6");
            }
            if (min > 0L) {
                sb.append(min + "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static Date getFirstDateOfMonth(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        Date date = c.getTime();
        return date;
    }

    public static String formatDate(Date d, String pattern) {
        SimpleDateFormat sf = new SimpleDateFormat(pattern);
        return sf.format(d);
    }

    public static Date parseToDate(String sDate, String pattern) throws ParseException {
        SimpleDateFormat sf = new SimpleDateFormat(pattern);
        return sf.parse(sDate);
    }

    public static Date getMinTime(Date dt) {
        Date dt1 = null;
        try {
            dt1 = DateUtils.parseToDate(DateUtils.formatDate(dt, "yyyyMMdd"), "yyyyMMdd");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dt1;
    }

    public static Date getMaxTime(Date dt) {
        Date dt1 = null;
        Calendar ca = Calendar.getInstance();
        ca.setTime(dt);
        ca.add(5, 1);
        dt1 = ca.getTime();
        dt1 = DateUtils.getMinTime(dt1);
        ca.setTime(dt1);
        ca.add(13, -1);
        dt1 = ca.getTime();
        return dt1;
    }

    public static Timestamp parseToTimestamp(Date date) {
        return new Timestamp(date.getTime());
    }

    public static String formatDate(Timestamp d, String pattern) {
        SimpleDateFormat sf = new SimpleDateFormat(pattern);
        return sf.format(d);
    }

    public static boolean isValidKey(String createKeyDate, long expire_time) {
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date now = new Date();
        try {
            Date createTime = dateformat.parse(createKeyDate);
            Date currentTime = dateformat.parse(dateformat.format(now));
            long time = (currentTime.getTime() - createTime.getTime()) / 1000L;
            return time > expire_time;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Date compareDateInNull(Date createDate, String absDays, String sourceDate2) {
        String loseReadyDateStr = DateUtils.getNextDay(DateUtils.formatDate(createDate, "yyyy-MM-dd HH:mm:ss"), absDays.toString());
        Date loseReadyDate = DateUtils.toDate(loseReadyDateStr, "yyyy-MM-dd HH:mm:ss");
        loseReadyDate = DateUtils.getMaxTime(loseReadyDate);
        if ("null".equals(sourceDate2) && "0".equals(absDays)) {
            return DateUtils.getMaxTime(new Date());
        }
        if ("null".equals(sourceDate2)) {
            return loseReadyDate;
        }
        if ("0".equals(absDays)) {
            Date sourceDate = DateUtils.getMaxTime(DateUtils.toDate(sourceDate2, "yyyy-MM-dd HH:mm:ss"));
            return sourceDate;
        }
        Date sourceDate = DateUtils.getMaxTime(DateUtils.toDate(sourceDate2, "yyyy-MM-dd HH:mm:ss"));
        if (loseReadyDate.after(sourceDate)) {
            return sourceDate;
        }
        return loseReadyDate;
    }

    public static boolean loseDate(Date loseDate) {
        Date nows = new Date();
        long hous = (nows.getTime() - loseDate.getTime()) / 1000L;
        return hous > 0L;
    }

    public static long differMinute(Date loseDate) {
        Date nows = new Date();
        long minute = (nows.getTime() - loseDate.getTime()) / 60000L;
        return minute;
    }

    public static boolean betweenBeginAndEnd(Date paramDate, Date beginDate, Date endDate) {
        long bHous = (paramDate.getTime() - beginDate.getTime()) / 1000L;
        long eHous = (endDate.getTime() - paramDate.getTime()) / 1000L;
        return bHous > 0L && eHous > 0L;
    }

    public static Date compareDate(Date createDate, String absDays, Date sourceDate2) {
        sourceDate2 = DateUtils.getMaxTime(sourceDate2);
        String loseReadyDateStr = DateUtils.getNextDay(DateUtils.formatDate(createDate, "yyyy-MM-dd HH:mm:ss"), absDays.toString());
        Date loseReadyDate = DateUtils.toDate(loseReadyDateStr, "yyyy-MM-dd HH:mm:ss");
        if ((loseReadyDate = DateUtils.getMaxTime(loseReadyDate)).after(sourceDate2)) {
            return sourceDate2;
        }
        return loseReadyDate;
    }

    public static String formatTime(int day, String standFormat) {
        String date = null;
        Calendar c = Calendar.getInstance();
        c.add(5, day);
        SimpleDateFormat format = new SimpleDateFormat(standFormat);
        date = format.format(c.getTime());
        return date;
    }

    public static String getTimeBeforeORAfter(int days, String pattern) {
        if (pattern == null) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Calendar c = Calendar.getInstance();
        c.add(5, days);
        return sdf.format(c.getTime());
    }

    public static String getTimeBeforeORAfter(Date date, int days, String pattern) {
        if (pattern == null || pattern == "") {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, days);
        return sdf.format(c.getTime());
    }

    public static boolean isAfterToday(String tocompareStr) throws ParseException {
        String pattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Date tocompareDate = sdf.parse(tocompareStr);
        return tocompareDate.after(Calendar.getInstance().getTime());
    }

    public static String getTimeBeforeOrAfterSenconds(Timestamp sourceTime, long seconds) {
        if (sourceTime != null) {
            long time = sourceTime.getTime() + seconds * 1000L;
            sourceTime.setTime(time);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format(sourceTime);
        }
        return "";
    }

    public static String getTimeBeforeOrAfterMonth(int months, String pattern, Date sourceTime) {
        if (pattern == null) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Calendar c = Calendar.getInstance();
        c.setTime(sourceTime);
        c.add(2, months);
        return sdf.format(c.getTime());
    }

    public static String getCurrentTime(String iFormat) {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat(iFormat);
        return format.format(date);
    }

    public static String toFormat(String iStrDate) {
        String strTemp = "";
        String strFlag = "";
        String strYear = "";
        String strMonth = "";
        String strDate = "";
        String strRet = "";
        int intStartPoint = 0;
        int intEndPoint = 0;
        if (iStrDate == null || iStrDate == "" || iStrDate.equals("null")) {
            return "";
        }
        if (iStrDate.length() < 8 || iStrDate.length() > 10) {
            return iStrDate;
        }
        if (iStrDate.indexOf("/") > 0) {
            strFlag = "/";
        }
        if (iStrDate.indexOf("-") > 0) {
            strFlag = "-";
        }
        if (strFlag.trim().equals("")) {
            System.err.println("\u8f93\u5165\u65e5\u671f\u4e32\u4e2d\u6ca1\u6709\u5206\u5272\u7b26!" + iStrDate);
            return iStrDate;
        }
        intStartPoint = iStrDate.indexOf(strFlag);
        intEndPoint = iStrDate.lastIndexOf(strFlag);
        strTemp = iStrDate.substring(0, intStartPoint);
        if (strTemp.length() == 4) {
            strYear = iStrDate.substring(0, intStartPoint);
            strMonth = iStrDate.substring(intStartPoint + 1, intEndPoint);
            if (strMonth.length() == 1) {
                strMonth = "0" + strMonth.trim();
            }
            if ((strDate = iStrDate.substring(intEndPoint + 1, iStrDate.length())).length() == 1) {
                strDate = "0" + strDate.trim();
            }
            strFlag = "-";
            strRet = strYear.trim() + strFlag.trim() + strMonth.trim() + strFlag.trim() + strDate.trim();
        }
        if (strTemp.length() != 4) {
            strMonth = iStrDate.substring(0, intStartPoint);
            if (strMonth.length() == 1) {
                strMonth = "0" + strMonth.trim();
            }
            if ((strDate = iStrDate.substring(intStartPoint + 1, intEndPoint)).length() == 1) {
                strDate = "0" + strDate.trim();
            }
            strYear = iStrDate.substring(intEndPoint + 1, iStrDate.length());
            strFlag = "-";
            strRet = strYear.trim() + strFlag.trim() + strMonth.trim() + strFlag.trim() + strDate.trim();
        }
        return strRet.trim();
    }

    public static String toWestFormat(String iStrDate, String iFormat) throws Exception {
        String strRet;
        block5: {
            String[] arrMonth = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
            String strYear = "";
            String strMonth = "";
            String strDate = "";
            strRet = "";
            int index = 0;
            try {
                strRet = DateUtils.toFormat(iStrDate);
                strYear = strRet.substring(0, 4);
                strMonth = strRet.substring(5, 7);
                strDate = strRet.substring(8, 10);
                index = Integer.parseInt(strMonth);
                strMonth = arrMonth[index - 1];
                if (iFormat.trim().equals("") || iFormat.trim().equals("MMddyyyy") || iFormat.trim().equals("MM.dd,yyyy")) {
                    strRet = strMonth + "." + strDate + "," + strYear;
                    break block5;
                }
                if (iFormat.trim().equals("dd-MM-yyyy")) {
                    strRet = strDate + "-" + strMonth + "-" + strYear;
                    break block5;
                }
                if (iFormat.trim().equals("yyyyMMdd")) {
                    strRet = strYear + "-" + strMonth + "-" + strDate;
                    break block5;
                }
                throw new Exception("\u65e5\u671f\u4e0d\u6b63\u786e\u6216\u4e0d\u5b58\u5728\u6b64\u65e5\u671f\u683c\u5f0f\uff01");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        return strRet.trim();
    }

    public static Date getYearLast() {
        Calendar currCal = Calendar.getInstance();
        int currentYear = currCal.get(1);
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, currentYear);
        calendar.roll(6, -1);
        Date currYearLast = calendar.getTime();
        return currYearLast;
    }

    public static Date getYearfirst() {
        Calendar currCal = Calendar.getInstance();
        int currentYear = currCal.get(1);
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, currentYear);
        Date currYearFirst = calendar.getTime();
        return currYearFirst;
    }

    public static String getTimeBeforeOrAfterYear(int years, String pattern, Date sourceTime) {
        if (pattern == null) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Calendar c = Calendar.getInstance();
        c.setTime(sourceTime);
        c.add(1, years);
        return sdf.format(c.getTime());
    }

    public static String getTimeBeforeOrAfterYearYYYYMMDDHHMMSS(int years, String pattern, Date sourceTime) {
        if (pattern == null) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Calendar c = Calendar.getInstance();
        c.setTime(sourceTime);
        c.add(1, years);
        c.add(5, -1);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        return sdf.format(c.getTime());
    }
}

