/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.data;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class Pages {
    public static <T, S> Page<T> convert(final Page<S> sourcePage, final PageConverter<S, T> pageConverter) {
        return new Page<T>(){

            public int getNumber() {
                return sourcePage.getNumber();
            }

            public int getSize() {
                return sourcePage.getSize();
            }

            public int getNumberOfElements() {
                return sourcePage.getNumberOfElements();
            }

            public List<T> getContent() {
                return new AbstractList<T>(){

                    @Override
                    public T get(int index) {
                        return pageConverter.convert(sourcePage.getContent().get(index));
                    }

                    @Override
                    public int size() {
                        return sourcePage.getContent().size();
                    }
                };
            }

            public boolean hasContent() {
                return sourcePage.hasContent();
            }

            public Sort getSort() {
                return sourcePage.getSort();
            }

            public boolean isFirst() {
                return sourcePage.isFirst();
            }

            public boolean isLast() {
                return sourcePage.isLast();
            }

            public boolean hasNext() {
                return sourcePage.hasNext();
            }

            public boolean hasPrevious() {
                return sourcePage.hasPrevious();
            }

            public Pageable nextPageable() {
                return sourcePage.nextPageable();
            }

            public Pageable previousPageable() {
                return sourcePage.previousPageable();
            }

            public Iterator<T> iterator() {
                return this.getContent().iterator();
            }

            public int getTotalPages() {
                return sourcePage.getTotalPages();
            }

            public long getTotalElements() {
                return sourcePage.getTotalElements();
            }

            public <S> Page<S> map(Converter<? super T, ? extends S> converter) {
                return null;
            }
        };
    }

    public static interface PageConverter<S, T> {
        public T convert(S var1);
    }
}

