/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.lang;

import java.io.IOException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.util.Assert;
import sinosoftgz.utils.Lang;

public class Springs
implements ApplicationListener<ContextRefreshedEvent> {
    private static ApplicationContext context;
    private static ResourceLoader resourceLoader;
    private static Environment parent;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        context = event.getApplicationContext();
    }

    public static <T> T getBean(Class<? extends T> beanClass, String beanName) {
        Assert.notNull((Object)context, (String)"The spring applicationContext was not initialized");
        return (T)context.getBean(beanName);
    }

    public static Object getBean(String beanName) {
        Assert.notNull((Object)context, (String)"The spring applicationContext was not initialized");
        return context.getBean(beanName);
    }

    public static <T> T getBean(Class<? extends T> beanClass) {
        Assert.notNull((Object)context, (String)"The spring applicationContext was not initialized");
        return (T)context.getBean(beanClass);
    }

    public static Environment getEnvironment(final String ... propertiesFiles) {
        if (propertiesFiles == null) {
            throw new IllegalStateException("propertiesFiles should not be null");
        }
        return new StandardEnvironment(){

            public void customizePropertySources(MutablePropertySources propertySources) {
                for (int i = 0; i < propertiesFiles.length; ++i) {
                    String propertiesFile = propertiesFiles[i];
                    Assert.notNull((Object)propertiesFile, (String)"propertiesFiles should not be contain a null value");
                    propertiesFile = parent.resolveRequiredPlaceholders(propertiesFile);
                    Resource resource = resourceLoader.getResource(propertiesFile);
                    if (!resource.exists()) {
                        throw new IllegalArgumentException(String.format("The resource %s is not exist", propertiesFile));
                    }
                    try {
                        propertySources.addLast((PropertySource)new ResourcePropertySource(resource.getFilename(), resource));
                        continue;
                    }
                    catch (IOException e) {
                        throw Lang.unchecked(e);
                    }
                }
                super.customizePropertySources(propertySources);
            }
        };
    }

    static {
        resourceLoader = new DefaultResourceLoader();
        parent = new StandardEnvironment(){};
    }
}

