/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.rpc.motan.filter;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.Activation;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.filter.Filter;
import com.weibo.api.motan.rpc.Caller;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.StringUtils;
import sinosoftgz.utils.Lang;
import sinosoftgz.utils.spring.ApplicationContextProvider;

@SpiMeta(name="openjpasession")
@Activation(sequence=100)
public class OpenEntityManagerInMotanFilter
implements Filter {
    private Logger logger = LoggerFactory.getLogger(OpenEntityManagerInMotanFilter.class);
    public static final String DEFAULT_ENTITY_MANAGER_FACTORY_BEAN_NAME = "entityManagerFactory";
    private String entityManagerFactoryBeanName;
    private String persistenceUnitName;
    private volatile EntityManagerFactory entityManagerFactory;
    private static ThreadLocal<Boolean> reentryFlag = new ThreadLocal();

    public void setEntityManagerFactoryBeanName(String entityManagerFactoryBeanName) {
        this.entityManagerFactoryBeanName = entityManagerFactoryBeanName;
    }

    protected String getEntityManagerFactoryBeanName() {
        return this.entityManagerFactoryBeanName;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    protected String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    protected EntityManagerFactory lookupEntityManagerFactory() {
        String emfBeanName = this.getEntityManagerFactoryBeanName();
        String puName = this.getPersistenceUnitName();
        if (StringUtils.hasLength((String)emfBeanName)) {
            return (EntityManagerFactory)ApplicationContextProvider.getApplicationContext().getBean(emfBeanName, EntityManagerFactory.class);
        }
        if (!StringUtils.hasLength((String)puName) && ApplicationContextProvider.getApplicationContext().containsBean(DEFAULT_ENTITY_MANAGER_FACTORY_BEAN_NAME)) {
            return (EntityManagerFactory)ApplicationContextProvider.getApplicationContext().getBean(DEFAULT_ENTITY_MANAGER_FACTORY_BEAN_NAME, EntityManagerFactory.class);
        }
        return EntityManagerFactoryUtils.findEntityManagerFactory((ListableBeanFactory)ApplicationContextProvider.getApplicationContext(), (String)puName);
    }

    protected EntityManager createEntityManager(EntityManagerFactory emf) {
        return emf.createEntityManager();
    }

    public Response filter(Caller<?> caller, Request request) {
        if (StringUtils.isEmpty(request.getAttachments().get(URLParamType.host.getName()))) {
            return caller.call(request);
        }
        EntityManagerFactory emf = null;
        try {
            emf = this.lookupEntityManagerFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (emf == null) {
            Response response = caller.call(request);
            return response;
        }
        try {
            if (Lang.isEmpty(TransactionSynchronizationManager.getResource((Object)emf))) {
                EntityManager em = this.createEntityManager(emf);
                EntityManagerHolder emHolder = new EntityManagerHolder(em);
                TransactionSynchronizationManager.bindResource((Object)emf, (Object)emHolder);
            }
        }
        catch (PersistenceException ex) {
            throw new DataAccessResourceFailureException("Could not create JPA EntityManager", (Throwable)ex);
        }
        finally {
            try {
                this.closeManager(emf);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        try {
            Response ex = caller.call(request);
            return ex;
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            this.closeManager(emf);
        }
    }

    private void closeManager(EntityManagerFactory emf) {
        if (!Lang.isEmpty(TransactionSynchronizationManager.getResource((Object)emf))) {
            EntityManagerHolder emHolder = null;
            try {
                emHolder = (EntityManagerHolder)TransactionSynchronizationManager.unbindResource((Object)emf);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            try {
                EntityManagerFactoryUtils.closeEntityManager((EntityManager)emHolder.getEntityManager());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

