/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.spring;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import sinosoftgz.utils.Lang;

@Component
@ConfigurationProperties(prefix="seqGenerator")
public final class SequenceGenerator
implements InitializingBean {
    static Map<String, String> createSqlMap = new ConcurrentHashMap<String, String>();
    static Map<String, String> insertSqlMap;
    TransactionTemplate transactionTemplate;
    boolean newTransaction = true;
    JdbcTemplate jdbcTemplate;
    int tryTime = 10;
    String databaseType;
    private String tableName;
    private int capacity = 25;
    private int step = 1;
    protected boolean recyclable;

    public static <T> T atom(Connection connection, Atom<T> atom) throws Exception {
        connection.setAutoCommit(false);
        connection.setTransactionIsolation(2);
        try {
            T obj = atom.atom(connection);
            connection.commit();
            return obj;
        }
        catch (Exception e) {
            connection.rollback();
            throw e;
        }
    }

    @Autowired
    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        if (transactionManager != null) {
            this.transactionTemplate = new TransactionTemplate(transactionManager);
            this.transactionTemplate.setIsolationLevel(2);
            this.transactionTemplate.setPropagationBehavior(0);
        }
    }

    public boolean isNewTransaction() {
        return this.newTransaction;
    }

    public void setNewTransaction(boolean newTransaction) {
        this.newTransaction = newTransaction;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Autowired
    public void setDataSource(DataSource dataSource) {
        if (this.jdbcTemplate == null) {
            this.jdbcTemplate = new JdbcTemplate(dataSource);
        }
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void setTryTime(int tryTime) {
        this.tryTime = tryTime;
    }

    public void setDatabaseType(String databaseType) {
        if (databaseType != null) {
            this.databaseType = databaseType = databaseType.trim().toLowerCase();
        }
    }

    public void setTableName(String tableName) {
        this.tableName = tableName == null ? null : tableName.trim();
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setStep(int step) {
        this.step = step < 1 ? 1 : step;
    }

    public void setRecyclable(boolean recyclable) {
        this.recyclable = recyclable;
    }

    public String generateSequence(String name, int length, long start) {
        long key = this.generateKey(name);
        try {
            return this.generateSequence(key, length, start, name);
        }
        catch (Throwable t) {
            int time;
            this.createSequenceTable();
            int n = time = this.tryTime >= 0 ? this.tryTime : 10000;
            while (time-- > 0) {
                try {
                    return this.generateSequence(key, length, start, name);
                }
                catch (Throwable throwable) {
                }
            }
            throw new RuntimeException("Generate sequence failure", t);
        }
    }

    private long generateKey(String name) {
        return 10000000000L + (long)name.trim().hashCode();
    }

    public String generateSequence(String key, int length) {
        return this.generateSequence(key, length, 0L);
    }

    public String generateSequence(String key) {
        return this.generateSequence(key, 6);
    }

    private synchronized void createSequenceTable() {
        try {
            this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Integer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Integer doInConnection(Connection connection) throws SQLException, DataAccessException {
                    try (ResultSet rs = connection.getMetaData().getTables(null, null, SequenceGenerator.this.tableName, null);){
                        if (rs.next()) {
                            Integer n = 1;
                            return n;
                        }
                    }
                    String createSql = String.format(createSqlMap.get(SequenceGenerator.this.databaseType), SequenceGenerator.this.tableName);
                    try (Statement statement = connection.createStatement();){
                        statement.execute(createSql);
                    }
                    return 0;
                }
            });
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateSequence(final long key, final int length, final long start, final String name) {
        if (this.newTransaction) {
            String string;
            Connection connection = this.jdbcTemplate.getDataSource().getConnection();
            try {
                string = SequenceGenerator.atom(connection, new Atom<String>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public String atom(Connection connection) throws Exception {
                        block12: {
                            String no;
                            if (SequenceGenerator.this.recyclable && (no = SequenceGenerator.this.getRecoveredSequence(connection, key, length)) != null) {
                                return no;
                            }
                            try (Statement statement = connection.createStatement();){
                                String insertSql = String.format(insertSqlMap.get(SequenceGenerator.this.databaseType), SequenceGenerator.this.tableName, key, name.replace("'", "''"), start < 0L ? 0L : start, SequenceGenerator.this.step, SequenceGenerator.this.tableName, key);
                                SequenceGenerator.this.execute(connection, insertSql, new Object[0]);
                                String querySql = String.format("select max(v$seq) from %s  where v$key=%d and v$state='1'", SequenceGenerator.this.tableName, key);
                                ResultSet rs = statement.executeQuery(querySql);
                                if (!rs.next()) break block12;
                                Long max = rs.getLong(1);
                                if (max < start) {
                                    String deleteSql = String.format("delete from %s where v$key=%d and v$state='1'", SequenceGenerator.this.tableName, key);
                                    SequenceGenerator.this.execute(connection, deleteSql, new Object[0]);
                                    insertSql = String.format(insertSqlMap.get(SequenceGenerator.this.databaseType), SequenceGenerator.this.tableName, key, name.replace("'", "''"), start < 0L ? 0L : start, SequenceGenerator.this.step, SequenceGenerator.this.tableName, key);
                                    SequenceGenerator.this.execute(connection, insertSql, new Object[0]);
                                    String string = SequenceGenerator.this.fillLeftZero(start, length);
                                    return string;
                                }
                                if (SequenceGenerator.this.capacity > 0 && max % (long)SequenceGenerator.this.capacity == 0L) {
                                    String deleteSql = String.format("delete from %s where v$key=%d and v$seq<>%d and v$state='1'", SequenceGenerator.this.tableName, key, max);
                                    SequenceGenerator.this.execute(connection, deleteSql, new Object[0]);
                                }
                                String string = SequenceGenerator.this.fillLeftZero(max, length);
                                return string;
                                finally {
                                    rs.close();
                                }
                            }
                        }
                        throw new IllegalStateException(SequenceGenerator.this.getClass().getSimpleName() + "\u65e0\u6cd5\u83b7\u53d6\u5355\u53f7\uff0c\u4e0d\u53ef\u80fd\u53d1\u751f\u7684\u5f02\u5e38");
                    }
                });
            }
            catch (Throwable throwable) {
                try {
                    connection.close();
                    throw throwable;
                }
                catch (Exception e) {
                    throw Lang.unchecked(e);
                }
            }
            connection.close();
            return string;
        }
        return (String)this.getTransactionTemplate().execute((TransactionCallback)new TransactionCallback<String>(){

            public String doInTransaction(TransactionStatus ts) {
                try {
                    String no;
                    if (SequenceGenerator.this.recyclable && (no = (String)SequenceGenerator.this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<String>(){

                        public String doInConnection(Connection connection) throws SQLException, DataAccessException {
                            return SequenceGenerator.this.getRecoveredSequence(connection, key, length);
                        }
                    })) != null) {
                        return no;
                    }
                    String insertSql = String.format(insertSqlMap.get(SequenceGenerator.this.databaseType), SequenceGenerator.this.tableName, key, name.replace("'", "''"), start < 0L ? 0L : start, SequenceGenerator.this.step, SequenceGenerator.this.tableName, key);
                    SequenceGenerator.this.execute(insertSql, new Object[0]);
                    String querySql = String.format("select max(v$seq) from %s  where v$key=%d and v$state='1'", SequenceGenerator.this.tableName, key);
                    Long max = (Long)SequenceGenerator.this.jdbcTemplate.queryForObject(querySql, Long.class);
                    if (max < start) {
                        String deleteSql = String.format("delete from %s where v$key=%d and v$state='1'", SequenceGenerator.this.tableName, key);
                        SequenceGenerator.this.execute(deleteSql, new Object[0]);
                        insertSql = String.format(insertSqlMap.get(SequenceGenerator.this.databaseType), SequenceGenerator.this.tableName, key, name.replace("'", "''"), start < 0L ? 0L : start, SequenceGenerator.this.step, SequenceGenerator.this.tableName, key);
                        SequenceGenerator.this.execute(insertSql, new Object[0]);
                        return SequenceGenerator.this.fillLeftZero(start, length);
                    }
                    if (SequenceGenerator.this.capacity > 0 && max % (long)SequenceGenerator.this.capacity == 0L) {
                        String deleteSql = String.format("delete from %s where v$key=%d and v$seq<>%d and v$state='1'", SequenceGenerator.this.tableName, key, max);
                        SequenceGenerator.this.execute(deleteSql, new Object[0]);
                    }
                    return SequenceGenerator.this.fillLeftZero(max, length);
                }
                catch (Throwable t) {
                    ts.isRollbackOnly();
                    throw new RuntimeException(t);
                }
            }
        });
    }

    protected int execute(String sql, final Object ... args) {
        return (Integer)this.jdbcTemplate.execute(sql, (PreparedStatementCallback)new PreparedStatementCallback<Integer>(){

            public Integer doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                if (args != null) {
                    for (int i = 0; i < args.length; ++i) {
                        ps.setObject(i + 1, args[i]);
                    }
                }
                return ps.executeUpdate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int execute(Connection conn, String sql, Object ... args) throws SQLException {
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    ps.setObject(i + 1, args[i]);
                }
            }
            int n = ps.executeUpdate();
            return n;
        }
    }

    protected String fillLeftZero(Long max, int length) {
        StringBuilder sb = new StringBuilder();
        sb.append(max);
        if (sb.length() >= length) {
            return sb.substring(sb.length() - length);
        }
        for (int i = sb.length(); i < length; ++i) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    /*
     * Exception decompiling
     */
    protected String getRecoveredSequence(Connection connection, long key, int length) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoveredSequence(final String name, String sequence) {
        block6: {
            final long key = this.generateKey(name);
            final long seq = Long.valueOf(sequence);
            if (this.newTransaction) {
                try (Connection connection = this.jdbcTemplate.getDataSource().getConnection();){
                    SequenceGenerator.atom(connection, new Atom<Object>(){

                        @Override
                        public Object atom(Connection connection) throws Exception {
                            String updateSql = String.format("update %s set v$state='0' where v$key=%d and v$seq=%d", SequenceGenerator.this.tableName, key, seq);
                            int count = SequenceGenerator.this.execute(connection, updateSql, new Object[0]);
                            if (count == 0) {
                                String insertSql = String.format("insert into %s(v$key,v$key$,v$seq,v$state) values(%d,'%s',%d,'0')", SequenceGenerator.this.tableName, key, name.replace("'", "''"), seq);
                                SequenceGenerator.this.execute(connection, insertSql, new Object[0]);
                            }
                            return null;
                        }
                    });
                    connection.commit();
                    break block6;
                }
                catch (Exception e) {
                    throw Lang.unchecked(e);
                }
            }
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Integer>(){

                public Integer doInTransaction(TransactionStatus status) {
                    try {
                        String updateSql = String.format("update %s set v$state='0' where v$key=%d and v$seq=%d", SequenceGenerator.this.tableName, key, seq);
                        int count = SequenceGenerator.this.execute(updateSql, new Object[0]);
                        if (count == 0) {
                            String insertSql = String.format("insert into %s(v$key,v$key$,v$seq,v$state) values(%d,'%s',%d,'0')", SequenceGenerator.this.tableName, key, name.replace("'", "''"), seq);
                            SequenceGenerator.this.execute(insertSql, new Object[0]);
                        }
                        return null;
                    }
                    catch (Throwable t) {
                        status.isRollbackOnly();
                        throw new RuntimeException(t);
                    }
                }
            });
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.databaseType == null) {
            throw new IllegalArgumentException(String.format("Property '%s' is required", "databaseType"));
        }
        if (this.databaseType != null && !createSqlMap.containsKey(this.databaseType)) {
            throw new IllegalStateException(String.format("Unsupported database type:%s", this.databaseType));
        }
        if (this.jdbcTemplate == null) {
            throw new IllegalArgumentException(String.format("Property '%s' or '%s' is required", "dataSource", "jdbcTemplate"));
        }
        if (this.tableName == null) {
            throw new IllegalArgumentException(String.format("Property '%s' is required", "tableName"));
        }
        if (!this.tableName.matches("[a-zA-Z_][a-zA-Z0-9_]*") || this.tableName.length() > 16) {
            throw new IllegalStateException(String.format("Illegal tableName:%s", this.tableName));
        }
        if (!this.newTransaction && this.transactionTemplate == null) {
            throw new IllegalArgumentException(String.format("Property '%s' is required", "transactionManager"));
        }
    }

    static {
        createSqlMap.put("h2", "CREATE TABLE %s (v$key BIGINT NOT NULL,v$key$ varchar(256),v$seq BIGINT NOT NULL,v$state CHAR(1) NOT NULL, PRIMARY KEY (v$key,v$seq))");
        createSqlMap.put("mysql", "CREATE TABLE %s (v$key BIGINT NOT NULL,v$key$ varchar(256),v$seq BIGINT NOT NULL,v$state CHAR(1) NOT NULL, PRIMARY KEY (v$key,v$seq))");
        createSqlMap.put("informix", "CREATE TABLE %s (v$key DECIMAL(16,0) NOT NULL,v$key$ varchar(256),v$seq DECIMAL(16,0) NOT NULL,v$state CHAR(1) NOT NULL, PRIMARY KEY (v$key,v$seq))");
        createSqlMap.put("oracle", "CREATE TABLE %s (v$key NUMBER(16,0) NOT NULL,v$key$ varchar2(256),v$seq NUMBER(16,0) NOT NULL,v$state CHAR(1) NOT NULL, PRIMARY KEY (v$key,v$seq))");
        insertSqlMap = new ConcurrentHashMap<String, String>();
        insertSqlMap.put("h2", "insert into %s(v$key,v$key$,v$seq,v$state) values(%d,'%s',(select ifnull(max(t.v$seq),%d)+%d from %s t where t.v$key=%d),'1')");
        insertSqlMap.put("mysql", "insert into %s(v$key,v$key$,v$seq,v$state) values(%d,'%s',(select ifnull(max(t.v$seq),%d)+%d from %s t where t.v$key=%d),'1')");
        insertSqlMap.put("informix", "insert into %s(v$key,v$key$,v$seq,v$state) values(%d,'%s',(select nvl(max(t.v$seq),%d)+%d from %s t where t.v$key=%d),'1')");
        insertSqlMap.put("oracle", "insert into %s(v$key,v$key$,v$seq,v$state) values(%d,'%s',(select nvl(max(t.v$seq),%d)+%d from %s t where t.v$key=%d),'1')");
    }

    static interface Atom<T> {
        public T atom(Connection var1) throws Exception;
    }
}

