/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.springmvc.converter.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.converter.HttpMessageNotWritableException;
import sinosoftgz.utils.springmvc.converter.fastjson.HibernatePropertyFilter;

public class HibernateFastJsonConverter
extends FastJsonHttpMessageConverter {
    private SerializeFilter[] serializeFilters;

    protected void writeInternal(Object obj, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        OutputStream out = outputMessage.getBody();
        if (this.serializeFilters == null || this.serializeFilters.length <= 0) {
            this.serializeFilters = new SerializeFilter[]{new HibernatePropertyFilter()};
        }
        String text = JSON.toJSONString((Object)obj, (SerializeFilter[])this.serializeFilters, (SerializerFeature[])super.getFeatures());
        byte[] bytes = text.getBytes(super.getCharset());
        out.write(bytes);
    }

    public SerializeFilter[] getSerializeFilters() {
        return this.serializeFilters;
    }

    public void setSerializeFilters(SerializeFilter ... serializeFilters) {
        Boolean added = false;
        for (SerializeFilter f : serializeFilters) {
            if (!f.getClass().equals(HibernatePropertyFilter.class)) continue;
            added = true;
            break;
        }
        if (!added.booleanValue()) {
            List<SerializeFilter> tmpArr = Arrays.asList(serializeFilters);
            tmpArr.add((SerializeFilter)new HibernatePropertyFilter());
            serializeFilters = tmpArr.toArray(new SerializeFilter[tmpArr.size()]);
        }
        this.serializeFilters = serializeFilters;
    }
}

