/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import sinosoftgz.utils.Lang;
import sinosoftgz.utils.data.Encodes;

public class Webs {
    public static final String JSONP_CALLBACK_NAME = "jsonpcallback";

    public static Map<String, Cookie> cookieMap(HttpServletRequest request) {
        Map<String, Cookie> cookieMap = Lang.newMap(new Object[0]);
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                cookieMap.put(cookie.getName(), cookie);
            }
        }
        return cookieMap;
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        return "XMLHttpRequest".equalsIgnoreCase(request.getHeader("X-Requested-With"));
    }

    public static String getIp(HttpServletRequest request) {
        String[] ss;
        String ip = request.getHeader("x-forwarded-for");
        if (Lang.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (Lang.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (Lang.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (Lang.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        for (String s : ss = ip.split(",")) {
            if ("unknown".equalsIgnoreCase(s)) continue;
            ip = s;
            break;
        }
        return ip;
    }

    public static PrintWriter getWriter(HttpServletResponse response) throws IOException {
        try {
            return response.getWriter();
        }
        catch (Exception e) {
            return new PrintWriter((OutputStream)response.getOutputStream());
        }
    }

    public static String addParamsWithTimestamp(String url, Object ... args) throws UnsupportedEncodingException {
        url = url + (url.indexOf("?") == -1 ? "?" : "&").concat(Long.toString(System.currentTimeMillis(), 36));
        return Webs.addParams(url, args);
    }

    private static String addParams(String url, Object ... args) throws UnsupportedEncodingException {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(url);
        if (args != null) {
            int n = 0;
            for (int i = 0; i < args.length; i += 2) {
                Object value;
                if (args.length <= i + 1 || (value = args[i + 1]) == null) continue;
                if (n == 0) {
                    if (url.indexOf("?") != -1) {
                        urlBuilder.append("&");
                    } else {
                        urlBuilder.append("?");
                    }
                } else {
                    urlBuilder.append("&");
                }
                Object name = args[i];
                urlBuilder.append(name);
                urlBuilder.append("=");
                urlBuilder.append(URLEncoder.encode(value.toString(), "UTF-8"));
                ++n;
            }
        }
        return urlBuilder.toString();
    }

    public static String getAbsUrl(HttpServletRequest req) {
        String encoding = req.getCharacterEncoding();
        encoding = encoding != null ? encoding : "UTF-8";
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(Webs.getAbsUri(req));
        Map paramMap = req.getParameterMap();
        if (!paramMap.isEmpty()) {
            urlBuilder.append("?");
            for (String name : paramMap.keySet()) {
                String[] values;
                if (Lang.equals(name, "username") || Lang.equals(name, "password")) continue;
                for (String value : values = (String[])paramMap.get(name)) {
                    if (urlBuilder.charAt(urlBuilder.length() - 1) != '?') {
                        urlBuilder.append('&');
                    }
                    urlBuilder.append(name);
                    urlBuilder.append('=');
                    try {
                        urlBuilder.append(URLEncoder.encode(value, encoding));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw Lang.unchecked(e);
                    }
                }
            }
        }
        return urlBuilder.toString();
    }

    public static String getAbsUri(HttpServletRequest req) {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(Webs.getAppUrl(req));
        urlBuilder.append(req.getRequestURI().substring(req.getContextPath().length()));
        return urlBuilder.toString();
    }

    public static String getAppUrl(HttpServletRequest req) {
        String host = req.getHeader("Host");
        if (host != null) {
            String scheme = req.getHeader("X-Forwarded-Proto");
            scheme = scheme != null ? scheme : req.getScheme();
            StringBuilder appUrlBuilder = new StringBuilder();
            appUrlBuilder.append(scheme);
            appUrlBuilder.append("://");
            appUrlBuilder.append(host);
            appUrlBuilder.append(req.getContextPath());
            return appUrlBuilder.toString();
        }
        String requestUrl = req.getRequestURL().toString();
        int pathLength = req.getRequestURI().length() - req.getContextPath().length();
        return requestUrl.substring(0, requestUrl.length() - pathLength);
    }

    public static Cookie getCookie(HttpServletRequest req, String name) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static String formRequest(String url, String method, Map<String, Object> paramMap, String charset) {
        StringBuilder htmlBuilder = new StringBuilder();
        String id = "id_" + UUID.randomUUID().toString().replace("-", "");
        htmlBuilder.append("<form id=\"");
        htmlBuilder.append(id);
        htmlBuilder.append("\" method=\"");
        htmlBuilder.append(method);
        htmlBuilder.append("\" action=\"");
        htmlBuilder.append(url);
        htmlBuilder.append("\"");
        if (charset != null) {
            htmlBuilder.append(" _input_charset=\"");
            htmlBuilder.append(charset);
            htmlBuilder.append("\"");
        }
        htmlBuilder.append(">");
        for (String name : paramMap.keySet()) {
            Object value = paramMap.get(name);
            if (Lang.isEmpty(value)) continue;
            htmlBuilder.append("<input type=\"hidden\" name=\"");
            htmlBuilder.append(name);
            htmlBuilder.append("\" value=\"");
            htmlBuilder.append(Encodes.escapeHtml(value.toString()));
            htmlBuilder.append("\">");
        }
        htmlBuilder.append("</form><script>document.getElementById('");
        htmlBuilder.append(id);
        htmlBuilder.append("').submit();</script>");
        return htmlBuilder.toString();
    }

    public static String formPost(String url, Map<String, Object> paramMap, String charset) {
        return Webs.formRequest(url, "post", paramMap, charset);
    }

    public static String formGet(String url, Map<String, Object> paramMap, String charset) {
        return Webs.formRequest(url, "get", paramMap, charset);
    }

    public static Map<String, Object> getParameterMap(String queryString, String charset) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        try {
            String[] params;
            for (String param : params = queryString.split("&")) {
                String value;
                String key;
                int p = param.indexOf("=");
                if (p == -1) {
                    key = URLDecoder.decode(param, charset);
                    value = null;
                } else {
                    key = URLDecoder.decode(param.substring(0, p), charset);
                    String string = value = param.length() > p + 1 ? URLDecoder.decode(param.substring(p + 1), charset) : "";
                }
                if (map.containsKey(key)) {
                    Object oldValue = map.get(key);
                    if (oldValue != null && oldValue.getClass().isArray()) {
                        String[] array = (String[])oldValue;
                        String[] newArray = new String[array.length + 1];
                        System.arraycopy(array, 0, newArray, 0, array.length);
                        newArray[array.length] = value;
                        map.put(key, newArray);
                        continue;
                    }
                    map.put(key, new String[]{(String)oldValue, value});
                    continue;
                }
                map.put(key, value);
            }
        }
        catch (Exception e) {
            throw Lang.unchecked(e);
        }
        return map;
    }

    public static Map<String, Object> getParameterMap(HttpServletRequest request, String charset) throws IOException {
        String parameterString = Webs.getParameterString(request, charset);
        return Webs.getParameterMap(parameterString, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getParameterString(HttpServletRequest request, String charset) throws IOException {
        StringBuilder queryBuilder = new StringBuilder();
        String queryString = request.getQueryString();
        if (queryString != null) {
            queryBuilder.append(queryString);
        }
        if ("post".equalsIgnoreCase(request.getMethod())) {
            if (request.getContentType() != null && request.getContentType().contains("multipart/form-data")) {
                throw new IllegalStateException(String.format("Can't handle the content type which contains %s", "multipart/form-data"));
            }
            try (ServletInputStream is = request.getInputStream();){
                String postString = IOUtils.toString((InputStream)is, (String)charset);
                if (postString.length() > 0) {
                    if (queryBuilder.length() > 0) {
                        queryBuilder.append('&');
                    }
                    queryBuilder.append(postString);
                } else {
                    Enumeration params = request.getParameterNames();
                    while (params.hasMoreElements()) {
                        if (queryBuilder.length() > 0) {
                            queryBuilder.append('&');
                        }
                        String key = (String)params.nextElement();
                        queryBuilder.append(key + "=" + request.getParameter(key));
                    }
                }
            }
        }
        String parameterString = queryBuilder.toString();
        return parameterString;
    }
}

