/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.Datum;
import oracle.sql.ROWID;

class RowidAccessor
extends Accessor {
    static final int maxLength = 128;
    static final int EXTENDED_ROWID_MAX_LENGTH = 18;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Nov_04_08:05:20_PDT_2011";
    public static final boolean TRACE = false;

    RowidAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        this.init(oracleStatement, 104, 9, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    RowidAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        this.init(oracleStatement, 104, 9, s2, false);
        this.initForDescribe(104, n2, bl, n3, n4, n5, n6, n7, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    @Override
    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.internalTypeMaxLength = 128;
        this.byteLength = this.internalTypeMaxLength + 2;
    }

    @Override
    String getString(int n2) throws SQLException {
        String string = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            string = new String(this.rowSpaceByte, n3 + 2, (int)s2);
        }
        return string;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        return this.getROWID(n2);
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        return this.getROWID(n2);
    }

    @Override
    ROWID getROWID(int n2) throws SQLException {
        byte[] byArray = this.getBytes(n2);
        return byArray == null ? null : new ROWID(byArray);
    }

    @Override
    byte[] getBytes(int n2) throws SQLException {
        byte[] byArray = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            int n3 = this.columnIndex + this.byteLength * n2;
            byArray = new byte[s2];
            System.arraycopy(this.rowSpaceByte, n3 + 2, byArray, 0, s2);
        }
        return byArray;
    }

    @Override
    Object getObject(int n2, Map map) throws SQLException {
        return this.getROWID(n2);
    }
}

