/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.TypeTreeElement;
import oracle.sql.Datum;
import oracle.sql.SQLName;
import oracle.sql.TypeDescriptor;

public abstract class OracleNamedType
extends OracleType
implements Serializable {
    transient OracleConnection connection;
    SQLName sqlName = null;
    transient OracleTypeADT parent = null;
    transient int idx;
    transient TypeDescriptor descriptor = null;
    static String getUserTypeTreeSql = "select level depth, parent_type, child_type, ATTR_NO, child_type_owner from  (select TYPE_NAME parent_type, ELEM_TYPE_NAME child_type, 0 ATTR_NO,       ELEM_TYPE_OWNER child_type_owner     from USER_COLL_TYPES  union   select TYPE_NAME parent_type, ATTR_TYPE_NAME child_type, ATTR_NO,       ATTR_TYPE_OWNER child_type_owner     from USER_TYPE_ATTRS  ) start with parent_type  = ?  connect by prior  child_type = parent_type";
    String sqlHint = null;
    static String getAllTypeTreeSql = "select parent_type, parent_type_owner, child_type, ATTR_NO, child_type_owner from ( select TYPE_NAME parent_type,  OWNER parent_type_owner,     ELEM_TYPE_NAME child_type, 0 ATTR_NO,     ELEM_TYPE_OWNER child_type_owner   from ALL_COLL_TYPES union   select TYPE_NAME parent_type, OWNER parent_type_owner,     ATTR_TYPE_NAME child_type, ATTR_NO,     ATTR_TYPE_OWNER child_type_owner   from ALL_TYPE_ATTRS ) start with parent_type  = ?  and parent_type_owner = ? connect by prior child_type = parent_type   and ( child_type_owner = parent_type_owner or child_type_owner is null )";
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Nov_04_08:05:20_PDT_2011";
    public static final boolean TRACE = false;

    protected OracleNamedType() {
    }

    public OracleNamedType(String string, OracleConnection oracleConnection) throws SQLException {
        this.setConnectionInternal(oracleConnection);
        this.sqlName = new SQLName(string, oracleConnection);
    }

    protected OracleNamedType(OracleTypeADT oracleTypeADT, int n2, OracleConnection oracleConnection) {
        this.setConnectionInternal(oracleConnection);
        this.parent = oracleTypeADT;
        this.idx = n2;
    }

    public String getFullName() throws SQLException {
        return this.getFullName(false);
    }

    public String getFullName(boolean bl) throws SQLException {
        String string = null;
        if (bl || this.sqlName == null) {
            if (this.parent != null && (string = this.parent.getAttributeType(this.idx)) != null) {
                this.sqlName = new SQLName(string, this.connection);
            } else {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to resolve name");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return this.sqlName.getName();
    }

    public String getSchemaName() throws SQLException {
        if (this.sqlName == null) {
            this.getFullName();
        }
        return this.sqlName.getSchema();
    }

    public String getSimpleName() throws SQLException {
        if (this.sqlName == null) {
            this.getFullName();
        }
        return this.sqlName.getSimpleName();
    }

    public boolean hasName() throws SQLException {
        return this.sqlName != null;
    }

    public OracleTypeADT getParent() throws SQLException {
        return this.parent;
    }

    public void setParent(OracleTypeADT oracleTypeADT) throws SQLException {
        this.parent = oracleTypeADT;
    }

    public int getOrder() throws SQLException {
        return this.idx;
    }

    public void setOrder(int n2) throws SQLException {
        this.idx = n2;
    }

    public OracleConnection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.setConnectionInternal(oracleConnection);
    }

    public void setConnectionInternal(OracleConnection oracleConnection) {
        this.connection = oracleConnection;
    }

    public Datum unlinearize(byte[] byArray, long l2, Datum datum, int n2, Map map) throws SQLException {
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public Datum unlinearize(byte[] byArray, long l2, Datum datum, long l3, int n2, int n3, Map map) throws SQLException {
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public byte[] linearize(Datum datum) throws SQLException {
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public TypeDescriptor getDescriptor() throws SQLException {
        return this.descriptor;
    }

    public void setDescriptor(TypeDescriptor typeDescriptor) throws SQLException {
        this.descriptor = typeDescriptor;
    }

    public int getTypeVersion() {
        return 1;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            objectOutputStream.writeUTF(this.getFullName());
        }
        catch (SQLException sQLException) {
            IOException iOException = DatabaseError.createIOException(sQLException);
            iOException.fillInStackTrace();
            throw iOException;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string = objectInputStream.readUTF();
        try {
            this.sqlName = new SQLName(string, null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.parent = null;
        this.idx = -1;
    }

    public void fixupConnection(OracleConnection oracleConnection) throws SQLException {
        if (this.connection == null) {
            this.setConnection(oracleConnection);
        }
    }

    @Override
    public void printXML(PrintWriter printWriter, int n2) throws SQLException {
        this.printXML(printWriter, n2, false);
    }

    @Override
    public void printXML(PrintWriter printWriter, int n2, boolean bl) throws SQLException {
        for (int i2 = 0; i2 < n2; ++i2) {
            printWriter.print("  ");
        }
        printWriter.println("<OracleNamedType/>");
    }

    @Override
    public void initNamesRecursively() throws SQLException {
        Map map = this.createTypesTreeMap();
        if (map.size() > 0) {
            this.initChildNamesRecursively(map);
        }
    }

    @Override
    public void setNames(String string, String string2) throws SQLException {
        this.sqlName = new SQLName(string, string2, this.connection);
    }

    public void setSqlName(SQLName sQLName) {
        this.sqlName = sQLName;
    }

    public Map createTypesTreeMap() throws SQLException {
        Map map = null;
        String string = this.connection.getDefaultSchemaNameForNamedTypes();
        if (this.sqlName.getSchema().equals(string)) {
            map = this.getNodeMapFromUserTypes();
        }
        if (map == null) {
            map = this.getNodeMapFromAllTypes();
        }
        return map;
    }

    String getSqlHint() throws SQLException {
        if (this.sqlHint == null) {
            this.sqlHint = this.connection.getVersionNumber() >= 11000 ? "" : "/*+RULE*/";
        }
        return this.sqlHint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getNodeMapFromUserTypes() throws SQLException {
        HashMap<SQLName, TypeTreeElement> hashMap = new HashMap<SQLName, TypeTreeElement>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.connection.prepareStatement(this.getSqlHint() + getUserTypeTreeSql);
            statement.setString(1, this.sqlName.getSimpleName());
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                int n2 = resultSet.getInt(1);
                String string = resultSet.getString(2);
                String string2 = resultSet.getString(3);
                int n3 = resultSet.getInt(4);
                String string3 = resultSet.getString(5);
                if (string3 != null && !string3.equals(this.sqlName.getSchema())) {
                    hashMap = null;
                    break;
                }
                if (string.length() <= 0) continue;
                SQLName sQLName = new SQLName(this.sqlName.getSchema(), string, this.connection);
                TypeTreeElement typeTreeElement = null;
                if (hashMap.containsKey(sQLName)) {
                    typeTreeElement = (TypeTreeElement)hashMap.get(sQLName);
                } else {
                    typeTreeElement = new TypeTreeElement(this.sqlName.getSchema(), string);
                    hashMap.put(sQLName, typeTreeElement);
                }
                typeTreeElement.putChild(this.sqlName.getSchema(), string2, n3);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getNodeMapFromAllTypes() throws SQLException {
        HashMap<SQLName, TypeTreeElement> hashMap = new HashMap<SQLName, TypeTreeElement>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.connection.prepareStatement(this.getSqlHint() + getAllTypeTreeSql);
            statement.setString(1, this.sqlName.getSimpleName());
            statement.setString(2, this.sqlName.getSchema());
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                int n2 = resultSet.getInt(4);
                String string4 = resultSet.getString(5);
                if (string4 == null) {
                    string4 = "SYS";
                }
                if (string.length() <= 0) continue;
                SQLName sQLName = new SQLName(string2, string, this.connection);
                TypeTreeElement typeTreeElement = null;
                if (hashMap.containsKey(sQLName)) {
                    typeTreeElement = (TypeTreeElement)hashMap.get(sQLName);
                } else {
                    typeTreeElement = new TypeTreeElement(string2, string);
                    hashMap.put(sQLName, typeTreeElement);
                }
                typeTreeElement.putChild(string4, string3, n2);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        return hashMap;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }
}

