/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.proxy;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.jdbc.proxy.AnnotationsRegistry;
import oracle.jdbc.proxy.ClassGenerator;
import oracle.jdbc.proxy.ExtractDelegatePermission;
import oracle.jdbc.proxy.GeneratedProxiesRegistry;
import oracle.jdbc.proxy.NullProxy;
import oracle.jdbc.proxy.OracleProxy;
import oracle.jdbc.proxy.WeakIdentityHashMap;
import oracle.jdbc.proxy._Proxy_;

public class ProxyFactory {
    final AnnotationsRegistry annotationsRegistry = new AnnotationsRegistry();
    private final GeneratedProxiesRegistry generatedRegistry = new GeneratedProxiesRegistry();
    private Map<Class, Class> delegateClassToProxyClass = Collections.synchronizedMap(new HashMap());
    private final Map<Object, WeakReference<Object>> delegateToProxy = Collections.synchronizedMap(new WeakIdentityHashMap());
    private Map<Class, Class> delegateToMostSuitableIface = new HashMap<Class, Class>();
    private static Object STALE_DELEGATE = new Object();
    private static final ExtractDelegatePermission EXTRACT_DELEGATE_PERMISSION = new ExtractDelegatePermission();

    private ProxyFactory() {
    }

    public static ProxyFactory createProxyFactory(Class ... classArray) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.annotationsRegistry.register(classArray);
        return proxyFactory;
    }

    public static ProxyFactory createJDBCProxyFactory(Class ... classArray) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.annotationsRegistry.register(NullProxy.class);
        proxyFactory.annotationsRegistry.register(classArray);
        return proxyFactory;
    }

    public final boolean isProxied(Class clazz) {
        return this.annotationsRegistry.containsKey(clazz);
    }

    public final <T> T proxyFor(T t) {
        return this.proxyFor(t, this);
    }

    public final <T> T proxyFor(T t, Object object) {
        return this.proxyFor(t, object, null, null);
    }

    public final <T> T proxyFor(T t, Object object, Map<Object, WeakReference<Object>> map, Method method) {
        Object object2;
        WeakReference<Object> weakReference;
        if (null == t) {
            return null;
        }
        Class<?> clazz = t.getClass();
        Class clazz2 = this.findMostSuitableIface(clazz);
        if (null != method && null != clazz2 && !method.getReturnType().isAssignableFrom(clazz2)) {
            return t;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(clazz2);
        if (null == value) {
            return t;
        }
        if (null == map) {
            Map<Object, Object> map2 = map = value.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
        }
        if (null != (weakReference = map.get(t)) && null != (object2 = weakReference.get())) {
            if (STALE_DELEGATE == object2) {
                throw new RuntimeException("stale delegate");
            }
            return (T)object2;
        }
        object2 = this.getProxyClass(clazz2, clazz);
        if (null == object2) {
            T t2 = this.createProxy(clazz2, t, object, map);
            map.put(t, new WeakReference<T>(t2));
            return t2;
        }
        try {
            Object t3 = ((Class)object2).getConstructor(clazz2, Object.class, ProxyFactory.class, Map.class).newInstance(t, object, this, map);
            map.put(t, new WeakReference(t3));
            return t3;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    public <T> void updateDelegate(Object object, T t, T t2) {
        this.delegateToProxy.put(t, new WeakReference<Object>(STALE_DELEGATE));
        this.delegateToProxy.put(t2, new WeakReference<Object>(object));
    }

    public static final Object extractDelegate(OracleProxy oracleProxy) {
        _Proxy_ _Proxy_2;
        SecurityManager securityManager = System.getSecurityManager();
        if (null != securityManager) {
            securityManager.checkPermission(EXTRACT_DELEGATE_PERMISSION);
        }
        try {
            _Proxy_2 = (_Proxy_)((Object)oracleProxy);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException();
        }
        return _Proxy_2._getDelegate_();
    }

    private <T> T createProxy(Class clazz, T t, Object object, Map<Object, WeakReference<Object>> map) {
        if (null == clazz) {
            return t;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(clazz);
        Class clazz2 = value.getSuperclass();
        GeneratedProxiesRegistry.Value value2 = this.generatedRegistry.get(clazz, clazz2);
        Constructor constructor = null == value2 ? this.prepareProxy(clazz, clazz2) : value2.getConstructor();
        try {
            return constructor.newInstance(t, object, this, map);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.getTargetException());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    private Constructor prepareProxy(Class clazz, Class clazz2) {
        Constructor constructor;
        Class clazz3 = null;
        try {
            clazz3 = Class.forName(new GeneratedProxiesRegistry.Key(clazz, clazz2).toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz3 = ClassGenerator.generate(clazz, clazz2, this.annotationsRegistry);
        }
        try {
            constructor = clazz3.getConstructor(clazz, Object.class, ProxyFactory.class, Map.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        this.generatedRegistry.put(clazz, clazz2, new GeneratedProxiesRegistry.Value(null, null, clazz3, constructor));
        return constructor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class getProxyClass(Class clazz, Class clazz2) {
        if (null == clazz2) {
            return null;
        }
        if (this.delegateClassToProxyClass.containsKey(clazz2)) {
            return this.delegateClassToProxyClass.get(clazz2);
        }
        if (null == clazz) {
            return null;
        }
        GeneratedProxiesRegistry.Value value = this.generatedRegistry.get(clazz, this.annotationsRegistry.get(clazz).getSuperclass());
        if (null == value) {
            return null;
        }
        Class clazz3 = value.getClazz();
        ProxyFactory proxyFactory = this;
        synchronized (proxyFactory) {
            HashMap<Class, Class> hashMap = new HashMap<Class, Class>(this.delegateClassToProxyClass);
            hashMap.put(clazz2, clazz3);
            this.delegateClassToProxyClass = hashMap;
        }
        return clazz3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class findMostSuitableIface(Class clazz) {
        if (null == clazz) {
            return null;
        }
        if (this.delegateToMostSuitableIface.containsKey(clazz)) {
            return this.delegateToMostSuitableIface.get(clazz);
        }
        int n2 = -1;
        Class serializable = null;
        for (Class serializable2 : this.annotationsRegistry.keySet()) {
            int n3 = this.intersectionCardinality(clazz, serializable2);
            if (n3 < 1 || n3 <= n2) continue;
            n2 = n3;
            serializable = serializable2;
        }
        ProxyFactory proxyFactory = this;
        synchronized (proxyFactory) {
            HashMap<Class, Class> hashMap = new HashMap<Class, Class>(this.delegateToMostSuitableIface);
            hashMap.put(clazz, serializable);
            this.delegateToMostSuitableIface = hashMap;
        }
        return serializable;
    }

    private int intersectionCardinality(Class clazz, Class clazz2) {
        HashSet<Class> hashSet = new HashSet<Class>();
        this.collectIfaces(clazz2, hashSet);
        HashSet<Class> hashSet2 = new HashSet<Class>();
        this.collectIfaces(clazz, hashSet2);
        int n2 = hashSet.size();
        hashSet.removeAll(hashSet2);
        if (hashSet.size() > 0) {
            return -1;
        }
        return n2;
    }

    private void collectIfaces(Class clazz, Set<Class> set) {
        if (clazz.isInterface()) {
            set.add(clazz);
        }
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            this.collectIfaces(clazz2, set);
        }
        Class clazz3 = clazz.getSuperclass();
        if (null != clazz3) {
            this.collectIfaces(clazz3, set);
        }
    }
}

