/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.replay.OracleDataSource;
import oracle.jdbc.replay.driver.NonTxnReplayableArray;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.NonTxnReplayableBfile;
import oracle.jdbc.replay.driver.NonTxnReplayableBlob;
import oracle.jdbc.replay.driver.NonTxnReplayableClob;
import oracle.jdbc.replay.driver.NonTxnReplayableConnection;
import oracle.jdbc.replay.driver.NonTxnReplayableNClob;
import oracle.jdbc.replay.driver.NonTxnReplayableOpaque;
import oracle.jdbc.replay.driver.NonTxnReplayableOthers;
import oracle.jdbc.replay.driver.NonTxnReplayableRef;
import oracle.jdbc.replay.driver.NonTxnReplayableResultSet;
import oracle.jdbc.replay.driver.NonTxnReplayableStatement;
import oracle.jdbc.replay.driver.NonTxnReplayableStruct;
import oracle.jdbc.replay.driver.ReplayLoggerFactory;
import oracle.jdbc.replay.internal.ConnectionInitializationCallback;
import oracle.jdbc.replay.internal.ReplayableConnection;

public class OracleDataSourceImpl
implements OracleDataSource,
Serializable,
Referenceable,
ObjectFactory {
    private static final long serialVersionUID = 5634196469087099680L;
    private static final String FEATURE_LOGGER_NAME = "oracle.jdbc.internal.replay.OracleDataSourceImpl";
    private static final Logger RDS_LOGGER = ReplayLoggerFactory.getLogger("oracle.jdbc.internal.replay.OracleDataSourceImpl");
    private static ProxyFactory PROXY_FACTORY = null;
    private String user = null;
    private String password = null;
    private String url = null;
    private String serverName = null;
    private int portNumber = 0;
    private String databaseName = null;
    private String dataSourceName = null;
    private String description = null;
    private String networkProtocol = null;
    private String roleName = null;
    private final Properties connectionProperties = new Properties();
    private int maxStatements = 0;
    private boolean implicitCachingEnabled = false;
    private boolean explicitCachingEnabled = false;
    private ConnectionInitializationCallback connectionInitializationCallback = null;
    private AtomicBoolean isFirstConnection = new AtomicBoolean(true);
    private static final String RECONNECT_DELAY_PROPERTY = "AUTH_FAILOVER_DELAY";
    private static final String RECONNECT_RETRIES_PROPERTY = "AUTH_FAILOVER_RETRIES";
    private int reconnectDelay = 10;
    private int reconnectRetries = 18;
    private static final String CHECKSUM_PROPERTY = "oracle.jdbc.calculateChecksum";

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        return this.getConnectionInternal(string, string2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnectionNoProxy() throws SQLException {
        int n2 = 1;
        Connection connection = null;
        Exception exception = null;
        do {
            try {
                if (this.reconnectDelay > 0) {
                    RDS_LOGGER.log(Level.FINER, "Reconnecting: DELAY for {0} seconds", this.reconnectDelay);
                    Thread.sleep(this.reconnectDelay * 1000);
                }
                RDS_LOGGER.log(Level.FINER, "Reconnecting: RETRY {0}", n2);
                exception = null;
                connection = this.getConnectionInternal(this.user, this.password, false);
            }
            catch (InterruptedException interruptedException) {
                connection = null;
                exception = interruptedException;
                RDS_LOGGER.log(Level.FINER, "Reconnect threw exception during DELAY: {0}", interruptedException);
            }
            catch (Exception exception2) {
                connection = null;
                exception = exception2;
                RDS_LOGGER.log(Level.FINER, "Reconnect FAILED, exception: {0}", exception2);
            }
            finally {
                if (connection != null && exception == null) {
                    return connection;
                }
                ++n2;
            }
        } while (n2 <= this.reconnectRetries);
        return null;
    }

    private Connection getConnectionInternal(String string, String string2, boolean bl) throws SQLException {
        Object object;
        Connection connection;
        Connection connection2 = null;
        oracle.jdbc.pool.OracleDataSource oracleDataSource = new oracle.jdbc.pool.OracleDataSource();
        oracleDataSource.setUser(string);
        oracleDataSource.setPassword(string2);
        oracleDataSource.setURL(this.getURL());
        this.setConnectionProperty(CHECKSUM_PROPERTY, "true");
        oracleDataSource.setConnectionProperties(this.getConnectionProperties());
        oracleDataSource.setMaxStatements(this.getMaxStatements());
        oracleDataSource.setImplicitCachingEnabled(this.getImplicitCachingEnabled());
        oracleDataSource.setExplicitCachingEnabled(this.getExplicitCachingEnabled());
        connection2 = oracleDataSource.getConnection();
        if (this.isFirstConnection.get()) {
            int n2;
            String string3;
            connection = (OracleConnection)connection2;
            object = connection.getServerSessionInfo();
            String string4 = ((Properties)object).getProperty(RECONNECT_DELAY_PROPERTY);
            if (string4 != null && !"".equals(string4)) {
                int n3 = Integer.parseInt(string4);
                if (n3 > 0) {
                    this.reconnectDelay = n3;
                } else {
                    RDS_LOGGER.log(Level.WARNING, "Server FAILOVER_DELAY: {0}, use driver default {1} seconds instead", new Object[]{n3, 10});
                }
            }
            if ((string3 = ((Properties)object).getProperty(RECONNECT_RETRIES_PROPERTY)) != null && !"".equals(string3)) {
                n2 = Integer.parseInt(string3);
                if (n2 > 0) {
                    this.reconnectRetries = n2;
                } else {
                    RDS_LOGGER.log(Level.WARNING, "Server FAILOVER_RETRIES: {0}, use driver default {1} instead", new Object[]{n2, 18});
                }
            }
            if ((n2 = connection.getVersionNumber()) < 11203) {
                throw DatabaseError.createSqlException(393);
            }
            this.isFirstConnection.set(false);
        }
        if (bl) {
            connection = PROXY_FACTORY.proxyFor(connection2);
            object = (ReplayableConnection)((Object)connection);
            object.initialize(this);
            return connection;
        }
        return connection2;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int n2) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String string) throws SQLException {
        RDS_LOGGER.log(Level.FINEST, "user: {0}", string);
        this.user = string;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String string) throws SQLException {
        this.password = string;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public void setURL(String string) throws SQLException {
        RDS_LOGGER.log(Level.FINEST, "URL: {0}", string);
        this.url = string;
    }

    @Override
    public void setServerName(String string) throws SQLException {
        RDS_LOGGER.log(Level.FINEST, "Server Name: {0}", string);
        this.serverName = string;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public void setPortNumber(int n2) throws SQLException {
        RDS_LOGGER.log(Level.FINEST, "Port Number: {0}", n2);
        this.portNumber = n2;
    }

    @Override
    public int getPortNumber() {
        return this.portNumber;
    }

    @Override
    public void setDatabaseName(String string) throws SQLException {
        RDS_LOGGER.log(Level.FINEST, "Database Name : {0}", string);
        this.databaseName = string;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public void setDataSourceName(String string) throws SQLException {
        RDS_LOGGER.log(Level.FINEST, "DataSourceName : {0}", string);
        this.dataSourceName = string;
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public void setDescription(String string) throws SQLException {
        RDS_LOGGER.log(Level.FINEST, "Description : {0}", string);
        this.description = string;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setNetworkProtocol(String string) throws SQLException {
        RDS_LOGGER.log(Level.FINEST, "networkProtocol : {0}", string);
        this.networkProtocol = string;
    }

    @Override
    public String getNetworkProtocol() {
        return this.networkProtocol;
    }

    @Override
    public void setRoleName(String string) throws SQLException {
        RDS_LOGGER.log(Level.FINEST, "RoleName : {0}", string);
        this.roleName = string;
    }

    @Override
    public String getRoleName() {
        return this.roleName;
    }

    @Override
    public void registerConnectionInitializationCallback(ConnectionInitializationCallback connectionInitializationCallback) throws SQLException {
        RDS_LOGGER.finest("Connection Initialization Callback registered");
        if (connectionInitializationCallback == null) {
            throw new NullPointerException("callback has to be non-null");
        }
        this.connectionInitializationCallback = connectionInitializationCallback;
    }

    @Override
    public void unregisterConnectionInitializationCallback(ConnectionInitializationCallback connectionInitializationCallback) throws SQLException {
        RDS_LOGGER.finest("Connection Initialization Callback removed");
        this.connectionInitializationCallback = null;
    }

    @Override
    public ConnectionInitializationCallback getConnectionInitializationCallback() {
        RDS_LOGGER.finest("connection initialization callback obtained");
        return this.connectionInitializationCallback;
    }

    @Override
    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    @Override
    public String getConnectionProperty(String string) {
        return this.connectionProperties.getProperty(string);
    }

    @Override
    public void setConnectionProperty(String string, String string2) throws SQLException {
        RDS_LOGGER.log(Level.FINEST, "name: {0}, value: {1}", new Object[]{string, string2});
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException();
        }
        this.connectionProperties.setProperty(string, string2);
    }

    @Override
    public void setConnectionProperties(Properties properties) throws SQLException {
        RDS_LOGGER.log(Level.FINEST, "ConnectionProperties: {0}", properties);
        if (properties.size() <= 0) {
            throw new IllegalArgumentException();
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.connectionProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    public void setMaxStatements(int n2) throws SQLException {
        this.maxStatements = n2;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return this.maxStatements;
    }

    @Override
    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        this.implicitCachingEnabled = bl;
    }

    @Override
    public boolean getImplicitCachingEnabled() throws SQLException {
        return this.implicitCachingEnabled;
    }

    @Override
    public void setExplicitCachingEnabled(boolean bl) throws SQLException {
        this.explicitCachingEnabled = bl;
    }

    @Override
    public boolean getExplicitCachingEnabled() throws SQLException {
        return this.explicitCachingEnabled;
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "oracle.jdbc.replay.OracleDataSourceImpl", null);
        if (this.user != null) {
            reference.add(new StringRefAddr("user", this.user));
        }
        if (this.password != null) {
            reference.add(new StringRefAddr("password", this.password));
        }
        if (this.url != null) {
            reference.add(new StringRefAddr("url", this.url));
        }
        if (this.serverName != null) {
            reference.add(new StringRefAddr("serverName", this.serverName));
        }
        reference.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
        if (this.databaseName != null) {
            reference.add(new StringRefAddr("databaseName", this.databaseName));
        }
        if (this.dataSourceName != null) {
            reference.add(new StringRefAddr("dataSourceName", this.dataSourceName.toString()));
        }
        if (this.description != null) {
            reference.add(new StringRefAddr("description", this.description.toString()));
        }
        if (this.networkProtocol != null) {
            reference.add(new StringRefAddr("networkProtocol", this.networkProtocol.toString()));
        }
        if (this.roleName != null) {
            reference.add(new StringRefAddr("roleName", this.roleName));
        }
        if (this.connectionProperties.size() > 0) {
            reference.add(new StringRefAddr("connectionProperties", this.connectionProperties.toString()));
        }
        if (this.maxStatements != 0) {
            reference.add(new StringRefAddr("maxStatements", Integer.toString(this.maxStatements)));
        }
        if (this.implicitCachingEnabled) {
            reference.add(new StringRefAddr("implicitCachingEnabled", "true"));
        }
        if (this.explicitCachingEnabled) {
            reference.add(new StringRefAddr("explicitCachingEnabled", "true"));
        }
        return reference;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, SQLException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        String string;
        Reference reference = (Reference)object;
        String string2 = reference.getClassName();
        OracleDataSourceImpl oracleDataSourceImpl = null;
        if (string2.equals("oracle.jdbc.replay.OracleDataSource") || string2.equals("oracle.jdbc.replay.OracleDataSourceImpl")) {
            oracleDataSourceImpl = new OracleDataSourceImpl();
        }
        if (oracleDataSourceImpl == null) {
            return null;
        }
        StringRefAddr stringRefAddr = (StringRefAddr)reference.get("user");
        if (stringRefAddr != null) {
            oracleDataSourceImpl.setUser((String)stringRefAddr.getContent());
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("password")) != null) {
            oracleDataSourceImpl.setPassword((String)stringRefAddr.getContent());
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("url")) != null) {
            oracleDataSourceImpl.setURL((String)stringRefAddr.getContent());
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("serverName")) != null) {
            oracleDataSourceImpl.setServerName((String)stringRefAddr.getContent());
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("portNumber")) != null) {
            oracleDataSourceImpl.setPortNumber(Integer.parseInt((String)stringRefAddr.getContent()));
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("databaseName")) != null) {
            oracleDataSourceImpl.setDatabaseName((String)stringRefAddr.getContent());
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("dataSourceName")) != null) {
            oracleDataSourceImpl.setDataSourceName((String)stringRefAddr.getContent());
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("description")) != null) {
            oracleDataSourceImpl.setDescription((String)stringRefAddr.getContent());
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("networkProtocol")) != null) {
            oracleDataSourceImpl.setNetworkProtocol((String)stringRefAddr.getContent());
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("roleName")) != null) {
            oracleDataSourceImpl.setRoleName((String)stringRefAddr.getContent());
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("connectionProperties")) != null) {
            String[] stringArray;
            string = (String)stringRefAddr.getContent();
            Properties properties = new Properties();
            for (String string3 : stringArray = string.substring(1, string.length() - 1).split(", ")) {
                String[] stringArray2 = string3.split("=");
                properties.setProperty(stringArray2[0], stringArray2[1]);
            }
            oracleDataSourceImpl.setConnectionProperties(properties);
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("maxStatements")) != null) {
            oracleDataSourceImpl.setMaxStatements(Integer.parseInt((String)stringRefAddr.getContent()));
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("implicitCachingEnabled")) != null) {
            string = (String)stringRefAddr.getContent();
            if (string.equalsIgnoreCase("true")) {
                oracleDataSourceImpl.setImplicitCachingEnabled(true);
            } else {
                oracleDataSourceImpl.setImplicitCachingEnabled(false);
            }
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("explicitCachingEnabled")) != null) {
            string = (String)stringRefAddr.getContent();
            if (string.equalsIgnoreCase("true")) {
                oracleDataSourceImpl.setExplicitCachingEnabled(true);
            } else {
                oracleDataSourceImpl.setExplicitCachingEnabled(false);
            }
        }
        return oracleDataSourceImpl;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInterface() && clazz.isInstance(this)) {
            return (T)this;
        }
        return null;
    }

    static {
        if (PROXY_FACTORY == null) {
            PROXY_FACTORY = ProxyFactory.createProxyFactory(NonTxnReplayableBase.class, NonTxnReplayableConnection.class, NonTxnReplayableStatement.class, NonTxnReplayableResultSet.class, NonTxnReplayableArray.class, NonTxnReplayableBfile.class, NonTxnReplayableBlob.class, NonTxnReplayableClob.class, NonTxnReplayableNClob.class, NonTxnReplayableOpaque.class, NonTxnReplayableRef.class, NonTxnReplayableStruct.class, NonTxnReplayableOthers.class);
        }
    }
}

