/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.math.BigDecimal;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.Datum;

public class BINARY_DOUBLE
extends Datum {
    static final long serialVersionUID = 6718338151847341754L;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Nov_04_08:05:20_PDT_2011";
    public static final boolean TRACE = false;

    public BINARY_DOUBLE() {
    }

    public BINARY_DOUBLE(byte[] byArray) {
        super(byArray);
    }

    public BINARY_DOUBLE(double d2) {
        super(BINARY_DOUBLE.doubleToCanonicalFormatBytes(d2));
    }

    public BINARY_DOUBLE(Double d2) {
        super(BINARY_DOUBLE.doubleToCanonicalFormatBytes(d2));
    }

    public BINARY_DOUBLE(String string) throws SQLException {
        this(BINARY_DOUBLE.stringToDouble(string));
    }

    public BINARY_DOUBLE(Boolean bl) {
        this(bl != false ? 1 : 0);
    }

    @Override
    public Object toJdbc() throws SQLException {
        return new Double(BINARY_DOUBLE.canonicalFormatBytesToDouble(this.getBytes()));
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.lang.String") == 0 || string.compareTo("java.lang.Double") == 0;
    }

    @Override
    public String stringValue() {
        String string = Double.toString(BINARY_DOUBLE.canonicalFormatBytesToDouble(this.getBytes()));
        return string;
    }

    @Override
    public double doubleValue() throws SQLException {
        return BINARY_DOUBLE.canonicalFormatBytesToDouble(this.getBytes());
    }

    @Override
    public BigDecimal bigDecimalValue() throws SQLException {
        return new BigDecimal(BINARY_DOUBLE.canonicalFormatBytesToDouble(this.getBytes()));
    }

    @Override
    public Object makeJdbcArray(int n2) {
        return new Double[n2];
    }

    private static double stringToDouble(String string) throws SQLException {
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            SQLException sQLException = DatabaseError.createSqlException(null, 59);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    static byte[] doubleToCanonicalFormatBytes(double d2) {
        double d3 = d2;
        if (d3 == 0.0) {
            d3 = 0.0;
        } else if (d3 != d3) {
            d3 = Double.NaN;
        }
        long l2 = Double.doubleToLongBits(d3);
        byte[] byArray = new byte[8];
        int n2 = (int)l2;
        int n3 = (int)(l2 >> 32);
        int n4 = n2;
        int n5 = n2 >>= 8;
        int n6 = n2 >>= 8;
        int n7 = n2 >>= 8;
        int n8 = n3;
        int n9 = n3 >>= 8;
        int n10 = n3 >>= 8;
        int n11 = n3 >>= 8;
        if ((n11 & 0x80) == 0) {
            n11 |= 0x80;
        } else {
            n11 ^= 0xFFFFFFFF;
            n10 ^= 0xFFFFFFFF;
            n9 ^= 0xFFFFFFFF;
            n8 ^= 0xFFFFFFFF;
            n7 ^= 0xFFFFFFFF;
            n6 ^= 0xFFFFFFFF;
            n5 ^= 0xFFFFFFFF;
            n4 ^= 0xFFFFFFFF;
        }
        byArray[7] = (byte)n4;
        byArray[6] = (byte)n5;
        byArray[5] = (byte)n6;
        byArray[4] = (byte)n7;
        byArray[3] = (byte)n8;
        byArray[2] = (byte)n9;
        byArray[1] = (byte)n10;
        byArray[0] = (byte)n11;
        return byArray;
    }

    static double canonicalFormatBytesToDouble(byte[] byArray) {
        int n2 = byArray[0];
        int n3 = byArray[1];
        int n4 = byArray[2];
        int n5 = byArray[3];
        int n6 = byArray[4];
        int n7 = byArray[5];
        int n8 = byArray[6];
        int n9 = byArray[7];
        if ((n2 & 0x80) != 0) {
            n2 &= 0x7F;
            n3 &= 0xFF;
            n4 &= 0xFF;
            n5 &= 0xFF;
            n6 &= 0xFF;
            n7 &= 0xFF;
            n8 &= 0xFF;
            n9 &= 0xFF;
        } else {
            n2 = ~n2 & 0xFF;
            n3 = ~n3 & 0xFF;
            n4 = ~n4 & 0xFF;
            n5 = ~n5 & 0xFF;
            n6 = ~n6 & 0xFF;
            n7 = ~n7 & 0xFF;
            n8 = ~n8 & 0xFF;
            n9 = ~n9 & 0xFF;
        }
        int n10 = n2 << 24 | n3 << 16 | n4 << 8 | n5;
        int n11 = n6 << 24 | n7 << 16 | n8 << 8 | n9;
        long l2 = (long)n10 << 32 | (long)n11 & 0xFFFFFFFFL;
        return Double.longBitsToDouble(l2);
    }
}

