/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.HashSet;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.Transition;
import org.antlr.tool.Grammar;

public class DFAOptimizer {
    public static boolean PRUNE_EBNF_EXIT_BRANCHES = true;
    public static boolean COLLAPSE_ALL_PARALLEL_EDGES = true;
    public static boolean MERGE_STOP_STATES = true;
    protected Set visited = new HashSet();
    protected Grammar grammar;

    public DFAOptimizer(Grammar grammar) {
        this.grammar = grammar;
    }

    public void optimize() {
        for (int i = 1; i <= this.grammar.getNumberOfDecisions(); ++i) {
            DFA dFA = this.grammar.getLookaheadDFA(i);
            this.optimize(dFA);
        }
    }

    protected void optimize(DFA dFA) {
        if (PRUNE_EBNF_EXIT_BRANCHES) {
            this.visited.clear();
            int n = dFA.getNFADecisionStartState().decisionStateType;
            if (dFA.isGreedy() && !dFA.isCyclic() && (n == 3 || n == 1)) {
                this.optimizeExitBranches(dFA.startState);
            }
        }
    }

    protected void optimizeExitBranches(DFAState dFAState) {
        Integer n = new Integer(dFAState.stateNumber);
        if (this.visited.contains(n)) {
            return;
        }
        this.visited.add(n);
        int n2 = dFAState.dfa.getNumberOfAlts();
        for (int i = 0; i < dFAState.getNumberOfTransitions(); ++i) {
            Transition transition = dFAState.transition(i);
            DFAState dFAState2 = (DFAState)transition.target;
            if (dFAState2.isAcceptState() && dFAState2.getUniquelyPredictedAlt() == n2) {
                dFAState.removeTransition(i);
                --i;
            }
            this.optimizeExitBranches(dFAState2);
        }
    }
}

