/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.xml.processes;

import org.drools.compiler.xml.processes.AbstractNodeHandler;
import org.drools.process.core.timer.Timer;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.node.TimerNode;
import org.drools.xml.ExtensibleXmlParser;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TimerNodeHandler
extends AbstractNodeHandler {
    protected Node createNode() {
        return new TimerNode();
    }

    public void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        TimerNode timerNode = (TimerNode)node;
        String delay = element.getAttribute("delay");
        String period = element.getAttribute("period");
        if (delay != null && delay.length() > 0 || period != null && period.length() > 0) {
            Timer timer = timerNode.getTimer();
            if (timer == null) {
                timer = new Timer();
                timerNode.setTimer(timer);
            }
            if (delay != null && delay.length() != 0) {
                timer.setDelay(delay);
            }
            if (period != null && period.length() != 0) {
                timer.setPeriod(period);
            }
        }
    }

    public Class generateNodeFor() {
        return TimerNode.class;
    }

    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        TimerNode timerNode = (TimerNode)node;
        this.writeNode("timerNode", (Node)timerNode, xmlDump, includeMeta);
        Timer timer = timerNode.getTimer();
        if (timer != null) {
            xmlDump.append("delay=\"" + timer.getDelay() + "\" ");
            if (timer.getPeriod() != null) {
                xmlDump.append(" period=\"" + timer.getPeriod() + "\" ");
            }
        }
        if (includeMeta && this.containsMetaData((Node)timerNode)) {
            xmlDump.append(">" + EOL);
            this.writeMetaData((Node)timerNode, xmlDump);
            this.endNode("timerNode", xmlDump);
        } else {
            this.endNode(xmlDump);
        }
    }
}

